/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryUsageBrokerTest
extends BrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryUsageBrokerTest.class);

    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    @Override
    protected PolicyEntry getDefaultPolicy() {
        PolicyEntry policy = super.getDefaultPolicy();
        policy.setProducerFlowControl(false);
        policy.setQueue(">");
        policy.setMemoryLimit(0x8000000L);
        return policy;
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        KahaDBStore kaha = new KahaDBStore();
        File directory = new File("target/activemq-data/kahadb");
        IOHelper.deleteChildren((File)directory);
        kaha.setDirectory(directory);
        kaha.deleteAllMessages();
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        return broker;
    }

    protected ConnectionFactory createConnectionFactory() {
        return new ActiveMQConnectionFactory(this.broker.getVmConnectorURI());
    }

    protected Connection createJmsConnection() throws JMSException {
        return this.createConnectionFactory().createConnection();
    }

    public void testMemoryUsage() throws Exception {
        Connection conn = this.createJmsConnection();
        Session session = conn.createSession(true, 1);
        Queue queue = session.createQueue("queue.a.b");
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 100000; ++i) {
            BytesMessage bm = session.createBytesMessage();
            bm.writeBytes(new byte[1024]);
            producer.send((Message)bm);
            if ((i + 1) % 100 != 0) continue;
            session.commit();
            int memoryUsagePercent = this.broker.getSystemUsage().getMemoryUsage().getPercentUsage();
            LOG.info(i + 1 + " messages have been sent; broker memory usage " + memoryUsagePercent + "%");
            MemoryUsageBrokerTest.assertTrue((String)"Used more than available broker memory", (memoryUsagePercent <= 100 ? 1 : 0) != 0);
        }
        session.commit();
        producer.close();
        session.close();
        conn.close();
    }
}

