/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class BaseNetworkTest {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected Connection localConnection;
    protected Connection remoteConnection;
    protected BrokerService localBroker;
    protected BrokerService remoteBroker;
    protected Session localSession;
    protected Session remoteSession;

    @Before
    public final void setUp() throws Exception {
        this.doSetUp(true);
    }

    @After
    public final void tearDown() throws Exception {
        this.doTearDown();
    }

    protected void doTearDown() throws Exception {
        if (this.localConnection != null) {
            this.localConnection.close();
        }
        if (this.remoteConnection != null) {
            this.remoteConnection.close();
        }
        if (this.localBroker != null) {
            this.localBroker.stop();
        }
        if (this.remoteBroker != null) {
            this.remoteBroker.stop();
        }
    }

    protected void doSetUp(boolean deleteAllMessages) throws Exception {
        this.remoteBroker = this.createRemoteBroker();
        this.remoteBroker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.remoteBroker.start();
        this.remoteBroker.waitUntilStarted();
        this.localBroker = this.createLocalBroker();
        this.localBroker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.localBroker.start();
        this.localBroker.waitUntilStarted();
        URI localURI = this.localBroker.getVmConnectorURI();
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(localURI);
        fac.setAlwaysSyncSend(true);
        fac.setDispatchAsync(false);
        this.localConnection = fac.createConnection();
        this.localConnection.setClientID("clientId");
        this.localConnection.start();
        URI remoteURI = this.remoteBroker.getVmConnectorURI();
        fac = new ActiveMQConnectionFactory(remoteURI);
        this.remoteConnection = fac.createConnection();
        this.remoteConnection.setClientID("clientId");
        this.remoteConnection.start();
        this.localSession = this.localConnection.createSession(false, 1);
        this.remoteSession = this.remoteConnection.createSession(false, 1);
    }

    protected String getRemoteBrokerURI() {
        return "org/apache/activemq/network/remoteBroker.xml";
    }

    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/localBroker.xml";
    }

    protected BrokerService createBroker(String uri) throws Exception {
        ClassPathResource resource = new ClassPathResource(uri);
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        resource = new ClassPathResource(uri);
        factory = new BrokerFactoryBean((Resource)resource);
        factory.afterPropertiesSet();
        BrokerService result = factory.getBroker();
        return result;
    }

    protected BrokerService createLocalBroker() throws Exception {
        return this.createBroker(this.getLocalBrokerURI());
    }

    protected BrokerService createRemoteBroker() throws Exception {
        return this.createBroker(this.getRemoteBrokerURI());
    }
}

