/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.usage.SystemUsage;

public class NetworkTestSupport
extends BrokerTestSupport {
    protected ArrayList<StubConnection> connections = new ArrayList();
    protected TransportConnector connector;
    protected PersistenceAdapter remotePersistenceAdapter;
    protected BrokerService remoteBroker;
    protected SystemUsage remoteMemoryManager;
    protected TransportConnector remoteConnector;
    protected boolean useJmx = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.remotePersistenceAdapter = this.createRemotePersistenceAdapter(true);
        this.remoteBroker = this.createRemoteBroker(this.remotePersistenceAdapter);
        this.remoteConnector = this.createRemoteConnector();
        this.remoteBroker.addConnector(this.remoteConnector);
        BrokerRegistry.getInstance().bind("remotehost", this.remoteBroker);
        this.remoteBroker.start();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker:()/localhost?persistent=false&useJmx=false&"));
        this.connector = this.createConnector();
        broker.addConnector(this.connector);
        broker.setUseJmx(this.useJmx);
        return broker;
    }

    protected TransportConnector createRemoteConnector() throws Exception, IOException, URISyntaxException {
        return new TransportConnector(TransportFactory.bind((URI)new URI(this.getRemoteURI())));
    }

    protected TransportConnector createConnector() throws Exception, IOException, URISyntaxException {
        return new TransportConnector(TransportFactory.bind((URI)new URI(this.getLocalURI())));
    }

    protected String getRemoteURI() {
        return "vm://remotehost";
    }

    protected String getLocalURI() {
        return "vm://localhost";
    }

    protected PersistenceAdapter createRemotePersistenceAdapter(boolean clean) throws Exception {
        if (this.remotePersistenceAdapter == null || clean) {
            this.remotePersistenceAdapter = new MemoryPersistenceAdapter();
        }
        return this.remotePersistenceAdapter;
    }

    protected BrokerService createRemoteBroker(PersistenceAdapter persistenceAdapter) throws Exception {
        BrokerService answer = new BrokerService();
        answer.setBrokerName("remote");
        answer.setUseJmx(this.useJmx);
        answer.setPersistenceAdapter(persistenceAdapter);
        return answer;
    }

    @Override
    protected StubConnection createConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.connector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createRemoteConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.remoteConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected Transport createTransport() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.connector.getServer().getConnectURI());
        return transport;
    }

    protected Transport createRemoteTransport() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.remoteConnector.getServer().getConnectURI());
        return transport;
    }

    protected void restartRemoteBroker() throws Exception {
        BrokerRegistry.getInstance().unbind("remotehost");
        this.remoteConnector.stop();
        this.remoteBroker.stop();
        this.remotePersistenceAdapter.stop();
        this.remotePersistenceAdapter = this.createRemotePersistenceAdapter(false);
        this.remotePersistenceAdapter.start();
        this.remoteBroker = this.createRemoteBroker(this.remotePersistenceAdapter);
        this.remoteBroker.addConnector(this.getRemoteURI());
        this.remoteBroker.start();
        BrokerRegistry.getInstance().bind("remotehost", this.remoteBroker);
    }

    @Override
    protected void tearDown() throws Exception {
        Iterator<StubConnection> iter = this.connections.iterator();
        while (iter.hasNext()) {
            StubConnection connection = iter.next();
            connection.stop();
            iter.remove();
        }
        BrokerRegistry.getInstance().unbind("remotehost");
        this.remoteConnector.stop();
        this.connector.stop();
        this.remoteBroker.stop();
        this.remoteBroker.waitUntilStopped();
        this.remotePersistenceAdapter.stop();
        super.tearDown();
    }
}

