/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryAllocationTest
extends TestCase {
    protected static final int MESSAGE_COUNT = 2000;
    private static final Logger LOG = LoggerFactory.getLogger(MemoryAllocationTest.class);
    protected BrokerService broker;
    protected String bindAddress = "vm://localhost";
    protected int topicCount;

    public void testPerformance() throws Exception {
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        Connection connection = factory.createConnection();
        for (int i = 0; i < 2000; ++i) {
            Session session = connection.createSession(false, 1);
            TemporaryTopic dest = session.createTemporaryTopic();
            session.createConsumer((Destination)dest);
            MessageProducer mp = session.createProducer((Destination)dest);
            TextMessage msg = session.createTextMessage("test" + i);
            mp.send((Message)msg);
            session.close();
            this.releaseDestination((Destination)dest);
            if (i % 500 != 0) continue;
            LOG.info("Iterator " + i);
        }
        connection.close();
    }

    protected Destination getDestination(Session session) throws JMSException {
        String topicName = ((Object)((Object)this)).getClass().getName() + "." + this.topicCount++;
        return session.createTopic(topicName);
    }

    protected void releaseDestination(Destination dest) throws JMSException {
        if (dest instanceof TemporaryTopic) {
            TemporaryTopic tt = (TemporaryTopic)dest;
            tt.delete();
        } else if (dest instanceof TemporaryQueue) {
            TemporaryQueue tq = (TemporaryQueue)dest;
            tq.delete();
        }
    }

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.bindAddress);
        return cf;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setPersistent(false);
        answer.addConnector(this.bindAddress);
        answer.setDeleteAllMessagesOnStartup(true);
    }
}

