/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.PerfProducer;
import org.apache.activemq.perf.PerfRate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTopicTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTopicTest.class);
    protected BrokerService broker;
    protected String clientURI = "tcp://localhost:61616?wireFormat.cacheEnabled=true&wireFormat.tightEncodingEnabled=true&jms.useAsyncSend=false&wireFormat.maxInactivityDuration=0";
    protected String bindAddress = "tcp://localhost:61616?wireFormat.maxInactivityDuration=0";
    protected PerfProducer[] producers;
    protected PerfConsumer[] consumers;
    protected String destinationName = ((Object)((Object)this)).getClass().getName();
    protected int sampleCount = 20;
    protected long sampleInternal = 10000L;
    protected int numberOfDestinations = 1;
    protected int numberOfConsumers = 1;
    protected int numberofProducers = 1;
    protected int totalNumberOfProducers;
    protected int totalNumberOfConsumers;
    protected int playloadSize = 12;
    protected byte[] array;
    protected ConnectionFactory factory;

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker(this.bindAddress);
        }
        this.factory = this.createConnectionFactory(this.clientURI);
        Connection con = this.factory.createConnection();
        Session session = con.createSession(false, 1);
        LOG.info("Running " + this.numberofProducers + " producer(s) and " + this.numberOfConsumers + " consumer(s) per " + this.numberOfDestinations + " Destination(s)");
        this.totalNumberOfConsumers = this.numberOfConsumers * this.numberOfDestinations;
        this.totalNumberOfProducers = this.numberofProducers * this.numberOfDestinations;
        this.producers = new PerfProducer[this.totalNumberOfProducers];
        this.consumers = new PerfConsumer[this.totalNumberOfConsumers];
        int consumerCount = 0;
        int producerCount = 0;
        for (int k = 0; k < this.numberOfDestinations; ++k) {
            int i;
            Destination destination = this.createDestination(session, this.destinationName + ":" + k);
            LOG.info("Testing against destination: " + destination);
            for (i = 0; i < this.numberOfConsumers; ++i) {
                this.consumers[consumerCount] = this.createConsumer(this.factory, destination, consumerCount);
                ++consumerCount;
            }
            for (i = 0; i < this.numberofProducers; ++i) {
                this.array = new byte[this.playloadSize];
                for (int j = i; j < this.array.length; ++j) {
                    this.array[j] = (byte)j;
                }
                this.producers[producerCount] = this.createProducer(this.factory, destination, i, this.array);
                ++producerCount;
            }
        }
        con.close();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        int i;
        super.tearDown();
        for (i = 0; i < this.numberOfConsumers; ++i) {
            this.consumers[i].shutDown();
        }
        for (i = 0; i < this.numberofProducers; ++i) {
            this.producers[i].shutDown();
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }

    protected Destination createDestination(Session s, String destinationName) throws JMSException {
        return s.createTopic(destinationName);
    }

    protected BrokerService createBroker(String uri) throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer, uri);
        answer.start();
        return answer;
    }

    protected PerfProducer createProducer(ConnectionFactory fac, Destination dest, int number, byte[] payload) throws JMSException {
        return new PerfProducer(fac, dest, payload);
    }

    protected PerfConsumer createConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        return new PerfConsumer(fac, dest);
    }

    protected void configureBroker(BrokerService answer, String uri) throws Exception {
        answer.setDeleteAllMessagesOnStartup(true);
        answer.addConnector(uri);
        answer.setUseShutdownHook(false);
    }

    protected ActiveMQConnectionFactory createConnectionFactory(String uri) throws Exception {
        return new ActiveMQConnectionFactory(uri);
    }

    public void testPerformance() throws JMSException, InterruptedException {
        int i;
        for (i = 0; i < this.totalNumberOfConsumers; ++i) {
            this.consumers[i].start();
        }
        for (i = 0; i < this.totalNumberOfProducers; ++i) {
            this.producers[i].start();
        }
        LOG.info("Sampling performance " + this.sampleCount + " times at a " + this.sampleInternal + " ms interval.");
        for (i = 0; i < this.sampleCount; ++i) {
            Thread.sleep(this.sampleInternal);
            this.dumpProducerRate();
            this.dumpConsumerRate();
        }
        for (i = 0; i < this.totalNumberOfProducers; ++i) {
            this.producers[i].stop();
        }
        for (i = 0; i < this.totalNumberOfConsumers; ++i) {
            this.consumers[i].stop();
        }
    }

    protected void dumpProducerRate() {
        int totalRate = 0;
        int totalCount = 0;
        Object producerString = "Producers:";
        for (int i = 0; i < this.producers.length; ++i) {
            PerfRate rate = this.producers[i].getRate().cloneAndReset();
            totalRate += rate.getRate();
            totalCount += rate.getTotalCount();
            producerString = (String)producerString + "[" + i + ":" + rate.getRate() + "," + rate.getTotalCount() + "];";
        }
        if (this.producers != null && this.producers.length > 0) {
            int avgRate = totalRate / this.producers.length;
            System.out.println("Avg producer rate = " + avgRate + " msg/sec | Total rate = " + totalRate + ", sent = " + totalCount);
        }
    }

    protected void dumpConsumerRate() {
        int totalRate = 0;
        int totalCount = 0;
        Object consumerString = "Consumers:";
        for (int i = 0; i < this.consumers.length; ++i) {
            PerfRate rate = this.consumers[i].getRate().cloneAndReset();
            totalRate += rate.getRate();
            totalCount += rate.getTotalCount();
            consumerString = (String)consumerString + "[" + i + ":" + rate.getRate() + "," + rate.getTotalCount() + "];";
        }
        if (this.consumers != null && this.consumers.length > 0) {
            int avgRate = totalRate / this.consumers.length;
            System.out.println("Avg consumer rate = " + avgRate + " msg/sec | Total rate = " + totalRate + ", received = " + totalCount);
            System.out.println((String)consumerString);
        }
    }
}

