/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.selector;

import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;

public class SelectorTest
extends TestCase {
    public void testBooleanSelector() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "(trueProp OR falseProp) AND trueProp", true);
        this.assertSelector(message, "(trueProp OR falseProp) AND falseProp", false);
        this.assertSelector(message, "trueProp", true);
        this.assertSelector(message, "(falseProp OR falseProp OR falseProp OR falseProp OR falseProp OR falseProp OR trueProp)", true);
        this.assertSelector(message, "(falseProp OR falseProp OR falseProp OR falseProp OR falseProp OR falseProp OR falseProp)", false);
        this.assertSelector(message, "(trueProp AND trueProp AND trueProp AND trueProp AND trueProp AND trueProp AND falseProp)", false);
        this.assertSelector(message, "(trueProp AND trueProp AND trueProp AND trueProp AND trueProp AND trueProp AND trueProp)", true);
    }

    public void testXPathSelectors() throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setJMSType("xml");
        message.setText("<root><a key='first' num='1'/><b key='second' num='2'>b</b></root>");
        this.assertSelector((javax.jms.Message)message, "XPATH 'root/a'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/b'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH 'root/c'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/b/text()=\"b\"'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/b=\"b\"'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/b=\"c\"'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/b!=\"c\"'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/*[@key=''second'']'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/*[@key=''third'']'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/a[@key=''first'']'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/a[@num=1]'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/a[@key=''second'']'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH '/root/*[@key=''first'' or @key=''third'']'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/*[@key=''third'' or @key=''forth'']'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH '/root/b=''b'' and /root/b[@key=''second'']'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '/root/b=''b'' and /root/b[@key=''first'']'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH 'not(//root/a)'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH 'not(//root/c)'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/a[not(@key=''first'')]'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/a[not(not(@key=''first''))]'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH 'string(//root/b)'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH 'string(//root/a)'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH 'sum(//@num) < 10'", true);
        this.assertSelector((javax.jms.Message)message, "XPATH 'sum(//@num) > 10'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/a[@num > 1]'", false);
        this.assertSelector((javax.jms.Message)message, "XPATH '//root/b[@num > 1]'", true);
    }

    public void testJMSPropertySelectors() throws Exception {
        javax.jms.Message message = this.createMessage();
        message.setJMSType("selector-test");
        message.setJMSMessageID("id:test:1:1:1:1");
        this.assertSelector(message, "JMSType = 'selector-test'", true);
        this.assertSelector(message, "JMSType = 'crap'", false);
        this.assertSelector(message, "JMSMessageID = 'id:test:1:1:1:1'", true);
        this.assertSelector(message, "JMSMessageID = 'id:not-test:1:1:1:1'", false);
        message = this.createMessage();
        message.setJMSType("1001");
        this.assertSelector(message, "JMSType='1001'", true);
        this.assertSelector(message, "JMSType='1001' OR JMSType='1002'", true);
        this.assertSelector(message, "JMSType = 'crap'", false);
    }

    public void testBasicSelectors() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "name = 'James'", true);
        this.assertSelector(message, "rank > 100", true);
        this.assertSelector(message, "rank >= 123", true);
        this.assertSelector(message, "rank >= 124", false);
    }

    public void testPropertyTypes() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "byteProp = 123", true);
        this.assertSelector(message, "byteProp = 10", false);
        this.assertSelector(message, "byteProp2 = 33", true);
        this.assertSelector(message, "byteProp2 = 10", false);
        this.assertSelector(message, "shortProp = 123", true);
        this.assertSelector(message, "shortProp = 10", false);
        this.assertSelector(message, "shortProp = 123", true);
        this.assertSelector(message, "shortProp = 10", false);
        this.assertSelector(message, "intProp = 123", true);
        this.assertSelector(message, "intProp = 10", false);
        this.assertSelector(message, "longProp = 123", true);
        this.assertSelector(message, "longProp = 10", false);
        this.assertSelector(message, "floatProp = 123", true);
        this.assertSelector(message, "floatProp = 10", false);
        this.assertSelector(message, "doubleProp = 123", true);
        this.assertSelector(message, "doubleProp = 10", false);
    }

    public void testAndSelectors() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "name = 'James' and rank < 200", true);
        this.assertSelector(message, "name = 'James' and rank > 200", false);
        this.assertSelector(message, "name = 'Foo' and rank < 200", false);
        this.assertSelector(message, "unknown = 'Foo' and anotherUnknown < 200", false);
    }

    public void testOrSelectors() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "name = 'James' or rank < 200", true);
        this.assertSelector(message, "name = 'James' or rank > 200", true);
        this.assertSelector(message, "name = 'Foo' or rank < 200", true);
        this.assertSelector(message, "name = 'Foo' or rank > 200", false);
        this.assertSelector(message, "unknown = 'Foo' or anotherUnknown < 200", false);
    }

    public void testPlus() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "rank + 2 = 125", true);
        this.assertSelector(message, "(rank + 2) = 125", true);
        this.assertSelector(message, "125 = (rank + 2)", true);
        this.assertSelector(message, "rank + version = 125", true);
        this.assertSelector(message, "rank + 2 < 124", false);
        this.assertSelector(message, "name + '!' = 'James!'", true);
    }

    public void testMinus() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "rank - 2 = 121", true);
        this.assertSelector(message, "rank - version = 121", true);
        this.assertSelector(message, "rank - 2 > 122", false);
    }

    public void testMultiply() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "rank * 2 = 246", true);
        this.assertSelector(message, "rank * version = 246", true);
        this.assertSelector(message, "rank * 2 < 130", false);
    }

    public void testDivide() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "rank / version = 61.5", true);
        this.assertSelector(message, "rank / 3 > 100.0", false);
        this.assertSelector(message, "rank / 3 > 100", false);
        this.assertSelector(message, "version / 2 = 1", true);
    }

    public void testBetween() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "rank between 100 and 150", true);
        this.assertSelector(message, "rank between 10 and 120", false);
    }

    public void testIn() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "name in ('James', 'Bob', 'Gromit')", true);
        this.assertSelector(message, "name in ('Bob', 'James', 'Gromit')", true);
        this.assertSelector(message, "name in ('Gromit', 'Bob', 'James')", true);
        this.assertSelector(message, "name in ('Gromit', 'Bob', 'Cheddar')", false);
        this.assertSelector(message, "name not in ('Gromit', 'Bob', 'Cheddar')", true);
    }

    public void testIsNull() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "dummy is null", true);
        this.assertSelector(message, "dummy is not null", false);
        this.assertSelector(message, "name is not null", true);
        this.assertSelector(message, "name is null", false);
    }

    public void testLike() throws Exception {
        javax.jms.Message message = this.createMessage();
        message.setStringProperty("modelClassId", "com.whatever.something.foo.bar");
        message.setStringProperty("modelInstanceId", "170");
        message.setStringProperty("modelRequestError", "abc");
        message.setStringProperty("modelCorrelatedClientId", "whatever");
        this.assertSelector(message, "modelClassId LIKE 'com.whatever.something.%' AND modelInstanceId = '170' AND (modelRequestError IS NULL OR modelCorrelatedClientId = 'whatever')", true);
        message.setStringProperty("modelCorrelatedClientId", "shouldFailNow");
        this.assertSelector(message, "modelClassId LIKE 'com.whatever.something.%' AND modelInstanceId = '170' AND (modelRequestError IS NULL OR modelCorrelatedClientId = 'whatever')", false);
        message = this.createMessage();
        message.setStringProperty("modelClassId", "com.whatever.something.foo.bar");
        message.setStringProperty("modelInstanceId", "170");
        message.setStringProperty("modelCorrelatedClientId", "shouldNotMatch");
        this.assertSelector(message, "modelClassId LIKE 'com.whatever.something.%' AND modelInstanceId = '170' AND (modelRequestError IS NULL OR modelCorrelatedClientId = 'whatever')", true);
    }

    public void testMatsHenricsonUseCases() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "SessionserverId=1870414179", false);
        message.setLongProperty("SessionserverId", 1870414179L);
        this.assertSelector(message, "SessionserverId=1870414179", true);
        message.setLongProperty("SessionserverId", 1234L);
        this.assertSelector(message, "SessionserverId=1870414179", false);
        this.assertSelector(message, "Command NOT IN ('MirrorLobbyRequest', 'MirrorLobbyReply')", false);
        message.setStringProperty("Command", "Cheese");
        this.assertSelector(message, "Command NOT IN ('MirrorLobbyRequest', 'MirrorLobbyReply')", true);
        message.setStringProperty("Command", "MirrorLobbyRequest");
        this.assertSelector(message, "Command NOT IN ('MirrorLobbyRequest', 'MirrorLobbyReply')", false);
        message.setStringProperty("Command", "MirrorLobbyReply");
        this.assertSelector(message, "Command NOT IN ('MirrorLobbyRequest', 'MirrorLobbyReply')", false);
    }

    public void testFloatComparisons() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "1.0 < 1.1", true);
        this.assertSelector(message, "-1.1 < 1.0", true);
        this.assertSelector(message, "1.0E1 < 1.1E1", true);
        this.assertSelector(message, "-1.1E1 < 1.0E1", true);
        this.assertSelector(message, "1. < 1.1", true);
        this.assertSelector(message, "-1.1 < 1.", true);
        this.assertSelector(message, "1.E1 < 1.1E1", true);
        this.assertSelector(message, "-1.1E1 < 1.E1", true);
        this.assertSelector(message, ".1 < .5", true);
        this.assertSelector(message, "-.5 < .1", true);
        this.assertSelector(message, ".1E1 < .5E1", true);
        this.assertSelector(message, "-.5E1 < .1E1", true);
        this.assertSelector(message, "4E10 < 5E10", true);
        this.assertSelector(message, "5E8 < 5E10", true);
        this.assertSelector(message, "-4E10 < 2E10", true);
        this.assertSelector(message, "-5E8 < 2E2", true);
        this.assertSelector(message, "4E+10 < 5E+10", true);
        this.assertSelector(message, "4E-10 < 5E-10", true);
    }

    public void testStringQuoteParsing() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "quote = '''In God We Trust'''", true);
    }

    public void testLikeComparisons() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "quote LIKE '''In G_d We Trust'''", true);
        this.assertSelector(message, "quote LIKE '''In Gd_ We Trust'''", false);
        this.assertSelector(message, "quote NOT LIKE '''In G_d We Trust'''", false);
        this.assertSelector(message, "quote NOT LIKE '''In Gd_ We Trust'''", true);
        this.assertSelector(message, "foo LIKE '%oo'", true);
        this.assertSelector(message, "foo LIKE '%ar'", false);
        this.assertSelector(message, "foo NOT LIKE '%oo'", false);
        this.assertSelector(message, "foo NOT LIKE '%ar'", true);
        this.assertSelector(message, "foo LIKE '!_%' ESCAPE '!'", true);
        this.assertSelector(message, "quote LIKE '!_%' ESCAPE '!'", false);
        this.assertSelector(message, "foo NOT LIKE '!_%' ESCAPE '!'", false);
        this.assertSelector(message, "quote NOT LIKE '!_%' ESCAPE '!'", true);
        this.assertSelector(message, "punctuation LIKE '!#$&()*+,-./:;<=>?@[\\]^`{|}~'", true);
    }

    public void testSpecialEscapeLiteral() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "foo LIKE '%_%' ESCAPE '%'", true);
        this.assertSelector(message, "endingUnderScore LIKE '_D7xlJIQn$_' ESCAPE '$'", true);
        this.assertSelector(message, "endingUnderScore LIKE '_D7xlJIQn__' ESCAPE '_'", true);
        this.assertSelector(message, "endingUnderScore LIKE '%D7xlJIQn%_' ESCAPE '%'", true);
        this.assertSelector(message, "endingUnderScore LIKE '%D7xlJIQn%'  ESCAPE '%'", true);
        this.assertSelector(message, "endingUnderScore LIKE '%D7xlJIQn%%'  ESCAPE '%'", false);
        this.assertSelector(message, "endingUnderScore LIKE '_D7xlJIQn\\_' ESCAPE '\\'", true);
        this.assertSelector(message, "endingUnderScore LIKE '%D7xlJIQn\\_' ESCAPE '\\'", true);
    }

    public void testInvalidSelector() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertInvalidSelector(message, "3+5");
        this.assertInvalidSelector(message, "True AND 3+5");
        this.assertInvalidSelector(message, "=TEST 'test'");
        this.assertInvalidSelector(message, "prop1 = prop2 foo AND string = 'Test'");
        this.assertInvalidSelector(message, "a = 1 AMD  b = 2");
    }

    public void testFunctionSelector() throws Exception {
        javax.jms.Message message = this.createMessage();
        this.assertSelector(message, "REGEX('1870414179', SessionserverId)", false);
        message.setLongProperty("SessionserverId", 1870414179L);
        this.assertSelector(message, "REGEX('1870414179', SessionserverId)", true);
        this.assertSelector(message, "REGEX('[0-9]*', SessionserverId)", true);
        this.assertSelector(message, "REGEX('^[1-8]*$', SessionserverId)", false);
        this.assertSelector(message, "REGEX('^[1-8]*$', SessionserverId)", false);
        this.assertSelector(message, "INLIST(SPLIT('Tom,Dick,George',','), name)", false);
        this.assertSelector(message, "INLIST(SPLIT('Tom,James,George',','), name)", true);
        this.assertSelector(message, "INLIST(MAKELIST('Tom','Dick','George'), name)", false);
        this.assertSelector(message, "INLIST(MAKELIST('Tom','James','George'), name)", true);
        this.assertSelector(message, "REGEX('connection1111', REPLACE(JMSMessageID,':',''))", true);
    }

    public void testMatchOriginalDestinationAttribute() throws Exception {
        ActiveMQMessage activeMQMessage = (ActiveMQMessage)this.createMessage();
        ActiveMQQueue originalDest = new ActiveMQQueue("QQ");
        activeMQMessage.setOriginalDestination((ActiveMQDestination)originalDest);
        this.assertSelector((javax.jms.Message)activeMQMessage, "JMSDestination='" + originalDest.getQualifiedName() + "'", true);
    }

    protected javax.jms.Message createMessage() throws JMSException {
        javax.jms.Message message = this.createMessage("FOO.BAR");
        message.setJMSType("selector-test");
        message.setJMSMessageID("connection:1:1:1:1");
        message.setObjectProperty("name", (Object)"James");
        message.setObjectProperty("location", (Object)"London");
        message.setByteProperty("byteProp", (byte)123);
        message.setByteProperty("byteProp2", (byte)33);
        message.setShortProperty("shortProp", (short)123);
        message.setIntProperty("intProp", 123);
        message.setLongProperty("longProp", 123L);
        message.setFloatProperty("floatProp", 123.0f);
        message.setDoubleProperty("doubleProp", 123.0);
        message.setIntProperty("rank", 123);
        message.setIntProperty("version", 2);
        message.setStringProperty("quote", "'In God We Trust'");
        message.setStringProperty("foo", "_foo");
        message.setStringProperty("punctuation", "!#$&()*+,-./:;<=>?@[\\]^`{|}~");
        message.setStringProperty("endingUnderScore", "XD7xlJIQn_");
        message.setBooleanProperty("trueProp", true);
        message.setBooleanProperty("falseProp", false);
        return message;
    }

    protected void assertInvalidSelector(javax.jms.Message message, String text) throws JMSException {
        try {
            SelectorParser.parse((String)text);
            SelectorTest.fail((String)"Created a valid selector");
        }
        catch (InvalidSelectorException invalidSelectorException) {
            // empty catch block
        }
    }

    protected void assertSelector(javax.jms.Message message, String text, boolean expected) throws JMSException {
        BooleanExpression selector = SelectorParser.parse((String)text);
        SelectorTest.assertTrue((String)"Created a valid selector", (selector != null ? 1 : 0) != 0);
        MessageEvaluationContext context = new MessageEvaluationContext();
        context.setMessageReference((MessageReference)((Message)message));
        boolean value = selector.matches(context);
        context.clear();
        SelectorTest.assertEquals((String)("Selector for: " + text), (boolean)expected, (boolean)value);
        SelectorTest.assertEquals((String)"ref 0", (int)0, (int)((ActiveMQMessage)message).getReferenceCount());
    }

    protected javax.jms.Message createMessage(String subject) throws JMSException {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setJMSDestination((Destination)new ActiveMQTopic(subject));
        return message;
    }
}

