/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.net.URI;
import java.util.Enumeration;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TopicSubscriber;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStoreStatTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractStoreStatTestSupport.class);
    protected static int defaultMessageSize = 1000;

    protected abstract BrokerService getBroker();

    protected abstract URI getBrokerConnectURI();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.activemq.broker.region.Destination consumeTestQueueMessages(String queueName) throws Exception {
        ActiveMQQueue activeMqQueue = new ActiveMQQueue(queueName);
        org.apache.activemq.broker.region.Destination dest = this.getBroker().getDestination((ActiveMQDestination)activeMqQueue);
        Connection connection = new ActiveMQConnectionFactory(this.getBrokerConnectURI()).createConnection();
        connection.setClientID("clientId2" + queueName);
        connection.start();
        Session session = connection.createSession(false, 1);
        javax.jms.Queue queue = session.createQueue(queueName);
        try {
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i = 0; i < 200; ++i) {
                consumer.receive();
            }
        }
        finally {
            connection.stop();
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.activemq.broker.region.Destination browseTestQueueMessages(String queueName) throws Exception {
        ActiveMQQueue activeMqQueue = new ActiveMQQueue(queueName);
        org.apache.activemq.broker.region.Destination dest = this.getBroker().getDestination((ActiveMQDestination)activeMqQueue);
        Connection connection = new ActiveMQConnectionFactory(this.getBrokerConnectURI()).createConnection();
        connection.setClientID("clientId2" + queueName);
        connection.start();
        Session session = connection.createSession(false, 1);
        javax.jms.Queue queue = session.createQueue(queueName);
        try {
            QueueBrowser queueBrowser = session.createBrowser(queue);
            Enumeration messages = queueBrowser.getEnumeration();
            while (messages.hasMoreElements()) {
                messages.nextElement();
            }
        }
        finally {
            connection.stop();
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.activemq.broker.region.Destination consumeDurableTestMessages(Connection connection, String sub, int size, String topicName, AtomicLong publishedMessageSize) throws Exception {
        ActiveMQTopic activeMqTopic = new ActiveMQTopic(topicName);
        org.apache.activemq.broker.region.Destination dest = this.getBroker().getDestination((ActiveMQDestination)activeMqTopic);
        Session session = connection.createSession(false, 1);
        javax.jms.Topic topic = session.createTopic(topicName);
        try {
            TopicSubscriber consumer = session.createDurableSubscriber(topic, sub);
            for (int i = 0; i < size; ++i) {
                ActiveMQMessage message = (ActiveMQMessage)consumer.receive();
                if (publishedMessageSize == null) continue;
                publishedMessageSize.addAndGet(-message.getSize());
            }
        }
        finally {
            session.close();
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Queue publishTestQueueMessages(int count, String queueName, int deliveryMode, int messageSize, AtomicLong publishedMessageSize) throws Exception {
        ActiveMQQueue activeMqQueue = new ActiveMQQueue(queueName);
        org.apache.activemq.broker.region.Destination dest = this.getBroker().getDestination((ActiveMQDestination)activeMqQueue);
        Connection connection = new ActiveMQConnectionFactory(this.getBrokerConnectURI()).createConnection();
        connection.setClientID("clientId" + queueName);
        connection.start();
        Session session = connection.createSession(false, 1);
        javax.jms.Queue queue = session.createQueue(queueName);
        try {
            MessageProducer prod = session.createProducer((Destination)queue);
            prod.setDeliveryMode(deliveryMode);
            for (int i = 0; i < count; ++i) {
                prod.send((Message)this.createMessage(i, session, messageSize, publishedMessageSize));
            }
        }
        finally {
            connection.close();
        }
        return (Queue)dest;
    }

    protected Topic publishTestMessagesDurable(Connection connection, String[] subNames, String topicName, int publishSize, int expectedSize, int messageSize, AtomicLong publishedMessageSize, Set<String> publishedMessages, boolean verifyBrowsing) throws Exception {
        return this.publishTestMessagesDurable(connection, subNames, topicName, publishSize, expectedSize, messageSize, publishedMessageSize, publishedMessages, verifyBrowsing, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Topic publishTestMessagesDurable(Connection connection, String[] subNames, String topicName, int publishSize, int expectedSize, int messageSize, AtomicLong publishedMessageSize, Set<String> publishedMessages, boolean verifyBrowsing, int deliveryMode) throws Exception {
        ActiveMQTopic activeMqTopic = new ActiveMQTopic(topicName);
        org.apache.activemq.broker.region.Destination dest = this.getBroker().getDestination((ActiveMQDestination)activeMqTopic);
        Session session = connection.createSession(false, 1);
        javax.jms.Topic topic = session.createTopic(topicName);
        for (String subName : subNames) {
            session.createDurableSubscriber(topic, subName);
        }
        ObjectName[] subs = null;
        if (verifyBrowsing) {
            subs = this.getBroker().getAdminView().getDurableTopicSubscribers();
        }
        try {
            MessageProducer prod = session.createProducer((Destination)topic);
            prod.setDeliveryMode(deliveryMode);
            for (int i = 0; i < publishSize; ++i) {
                BytesMessage message = this.createMessage(i, session, messageSize, publishedMessageSize);
                prod.send((Message)message);
                if (publishedMessages == null) continue;
                publishedMessages.add(message.getJMSMessageID());
            }
            if (verifyBrowsing) {
                Assert.assertNotNull((Object)subs);
                Assert.assertEquals((long)subNames.length, (long)subs.length);
                ObjectName subName = subs[0];
                DurableSubscriptionViewMBean sub = (DurableSubscriptionViewMBean)this.getBroker().getManagementContext().newProxyInstance(subName, DurableSubscriptionViewMBean.class, true);
                CompositeData[] data = sub.browse();
                Assert.assertNotNull((Object)data);
                Assert.assertEquals((long)expectedSize, (long)data.length);
            }
        }
        finally {
            session.close();
        }
        return (Topic)dest;
    }

    protected BytesMessage createMessage(int count, Session session, int maxMessageSize, AtomicLong publishedMessageSize) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        Random randomSize = new Random();
        int size = randomSize.nextInt(maxMessageSize - 100 + 1) + 100;
        LOG.info("Creating message to publish: " + count + ", size: " + size);
        if (publishedMessageSize != null) {
            publishedMessageSize.addAndGet(size);
        }
        byte[] data = new byte[size];
        Random rng = new Random();
        rng.nextBytes(data);
        message.writeBytes(data);
        return message;
    }
}

