/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.File;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkBrokerDetachTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.IOHelper;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.junit.After;
import org.junit.BeforeClass;

public class JDBCNetworkBrokerDetachTest
extends NetworkBrokerDetachTest {
    LinkedList<EmbeddedDataSource> dataSources = new LinkedList();

    @Override
    protected void configureBroker(BrokerService broker) throws Exception {
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        try {
            EmbeddedDataSource dataSource = (EmbeddedDataSource)DataSourceServiceSupport.createDataSource((String)jdbc.getDataDirectoryFile().getCanonicalPath(), (String)broker.getBrokerName());
            dataSource.getConnection().close();
            jdbc.setDataSource((DataSource)dataSource);
            this.dataSources.add(dataSource);
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLException n = e.getNextException();
            while (n != null) {
                n.printStackTrace();
                if (!(n instanceof SQLException)) continue;
                n = n.getNextException();
            }
            throw e;
        }
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
        broker.setUseVirtualTopics(false);
    }

    @After
    public void shutdownDataSources() throws Exception {
        for (EmbeddedDataSource ds : this.dataSources) {
            DataSourceServiceSupport.shutdownDefaultDataSource((DataSource)ds);
        }
        this.dataSources.clear();
    }

    @BeforeClass
    public static void ensureDerbyHasCleanDirectory() throws Exception {
        IOHelper.delete((File)new File(IOHelper.getDefaultDataDirectory()));
    }
}

