/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.rollback;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.MessageCreator;

public class CloseRollbackRedeliveryQueueTest
extends EmbeddedBrokerTestSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(CloseRollbackRedeliveryQueueTest.class);
    protected int numberOfMessagesOnQueue = 1;
    private Connection connection;

    public void testVerifySessionCloseRedeliveryWithFailoverTransport() throws Throwable {
        Session session = this.connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        Message message = consumer.receive(1000L);
        String id = message.getJMSMessageID();
        CloseRollbackRedeliveryQueueTest.assertNotNull((Object)message);
        LOG.info("got message " + message);
        session.close();
        session = this.connection.createSession(true, 0);
        consumer = session.createConsumer((Destination)this.destination);
        message = consumer.receive(1000L);
        session.commit();
        CloseRollbackRedeliveryQueueTest.assertNotNull((Object)message);
        CloseRollbackRedeliveryQueueTest.assertEquals((String)"redelivered message", (String)id, (String)message.getJMSMessageID());
        CloseRollbackRedeliveryQueueTest.assertEquals((long)2L, (long)message.getLongProperty("JMSXDeliveryCount"));
    }

    public void testVerifyConsumerAndSessionCloseRedeliveryWithFailoverTransport() throws Throwable {
        Session session = this.connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        Message message = consumer.receive(1000L);
        String id = message.getJMSMessageID();
        CloseRollbackRedeliveryQueueTest.assertNotNull((Object)message);
        LOG.info("got message " + message);
        consumer.close();
        session.close();
        session = this.connection.createSession(true, 0);
        consumer = session.createConsumer((Destination)this.destination);
        message = consumer.receive(1000L);
        session.commit();
        CloseRollbackRedeliveryQueueTest.assertNotNull((Object)message);
        CloseRollbackRedeliveryQueueTest.assertEquals((String)"redelivered message", (String)id, (String)message.getJMSMessageID());
        CloseRollbackRedeliveryQueueTest.assertEquals((long)2L, (long)message.getLongProperty("JMSXDeliveryCount"));
    }

    public void testVerifyConsumerCloseSessionRollbackRedeliveryWithFailoverTransport() throws Throwable {
        Session session = this.connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        Message message = consumer.receive(1000L);
        String id = message.getJMSMessageID();
        CloseRollbackRedeliveryQueueTest.assertNotNull((Object)message);
        LOG.info("got message " + message);
        consumer.close();
        session.rollback();
        consumer = session.createConsumer((Destination)this.destination);
        message = consumer.receive(1000L);
        session.commit();
        CloseRollbackRedeliveryQueueTest.assertNotNull((Object)message);
        CloseRollbackRedeliveryQueueTest.assertEquals((String)"redelivered message", (String)id, (String)message.getJMSMessageID());
        CloseRollbackRedeliveryQueueTest.assertEquals((long)2L, (long)message.getLongProperty("JMSXDeliveryCount"));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        for (int i = 0; i < this.numberOfMessagesOnQueue; ++i) {
            this.template.send(this.createMessageCreator(i));
        }
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("failover:" + this.bindAddress);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected MessageCreator createMessageCreator(final int i) {
        return new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage answer = session.createTextMessage("Message: " + i);
                answer.setIntProperty("Counter", i);
                return answer;
            }
        };
    }
}

