/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.reliable;

import java.util.Queue;
import junit.framework.TestCase;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.transport.StubTransport;
import org.apache.activemq.transport.StubTransportListener;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.reliable.ExceptionIfDroppedReplayStrategy;
import org.apache.activemq.transport.reliable.ReliableTransport;
import org.apache.activemq.transport.reliable.ReplayStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReliableTransportTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ReliableTransportTest.class);
    protected ReliableTransport transport;
    protected StubTransportListener listener = new StubTransportListener();
    protected ReplayStrategy replayStrategy;

    public void testValidSequenceOfPackets() throws Exception {
        int[] sequenceNumbers = new int[]{1, 2, 3, 4, 5, 6, 7};
        this.sendStreamOfCommands(sequenceNumbers, true);
    }

    public void testValidWrapAroundPackets() throws Exception {
        int[] sequenceNumbers = new int[10];
        int value = 0x7FFFFFFC;
        this.transport.setExpectedCounter(value);
        for (int i = 0; i < 10; ++i) {
            LOG.info("command: " + i + " = " + value);
            sequenceNumbers[i] = value++;
        }
        this.sendStreamOfCommands(sequenceNumbers, true);
    }

    public void testDuplicatePacketsDropped() throws Exception {
        int[] sequenceNumbers = new int[]{1, 2, 2, 3, 4, 5, 6, 7};
        this.sendStreamOfCommands(sequenceNumbers, true, 7);
    }

    public void testOldDuplicatePacketsDropped() throws Exception {
        int[] sequenceNumbers = new int[]{1, 2, 3, 4, 5, 2, 6, 7};
        this.sendStreamOfCommands(sequenceNumbers, true, 7);
    }

    public void testOldDuplicatePacketsDroppedUsingNegativeCounters() throws Exception {
        int[] sequenceNumbers = new int[]{-3, -1, -3, -2, -1, 0, 1, -1, 3, 2, 0, 2, 4};
        this.transport.setExpectedCounter(-3);
        this.sendStreamOfCommands(sequenceNumbers, true, 8);
    }

    public void testWrongOrderOfPackets() throws Exception {
        int[] sequenceNumbers = new int[]{4, 3, 1, 5, 2, 7, 6, 8, 10, 9};
        this.sendStreamOfCommands(sequenceNumbers, true);
    }

    public void testMissingPacketsFails() throws Exception {
        int[] sequenceNumbers = new int[]{1, 2, 4, 5, 6, 7, 8, 9, 10};
        this.sendStreamOfCommands(sequenceNumbers, false);
    }

    protected void sendStreamOfCommands(int[] sequenceNumbers, boolean expected) {
        this.sendStreamOfCommands(sequenceNumbers, expected, sequenceNumbers.length);
    }

    protected void sendStreamOfCommands(int[] sequenceNumbers, boolean expected, int expectedCount) {
        Exception e;
        for (int i = 0; i < sequenceNumbers.length; ++i) {
            int commandId = sequenceNumbers[i];
            ConsumerInfo info = new ConsumerInfo();
            info.setSelector("Cheese: " + commandId);
            info.setCommandId(commandId);
            this.transport.onCommand((Object)info);
        }
        Queue<Object> exceptions = this.listener.getExceptions();
        Queue<Object> commands = this.listener.getCommands();
        if (expected) {
            if (!exceptions.isEmpty()) {
                e = (Exception)exceptions.remove();
                e.printStackTrace();
                ReliableTransportTest.fail((String)("Caught exception: " + e));
            }
            ReliableTransportTest.assertEquals((String)"number of messages received", (int)expectedCount, (int)commands.size());
            ReliableTransportTest.assertEquals((String)"Should have no buffered commands", (int)0, (int)this.transport.getBufferedCommandCount());
        } else {
            ReliableTransportTest.assertTrue((String)"Should have received an exception!", (exceptions.size() > 0 ? 1 : 0) != 0);
            e = (Exception)exceptions.remove();
            LOG.info("Caught expected response: " + e);
        }
    }

    protected void setUp() throws Exception {
        if (this.replayStrategy == null) {
            this.replayStrategy = new ExceptionIfDroppedReplayStrategy();
        }
        this.transport = new ReliableTransport((Transport)new StubTransport(), this.replayStrategy);
        this.transport.setTransportListener((TransportListener)this.listener);
        this.transport.start();
    }
}

