/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.AsyncCallback;
import org.apache.activemq.TestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSendWithAsyncCallbackTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsSendWithAsyncCallbackTest.class);
    private Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    public void testAsyncCallbackIsFaster() throws JMSException, InterruptedException {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.getName());
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        for (int i = 0; i < 10; ++i) {
            this.benchmarkNonCallbackRate();
            this.benchmarkCallbackRate();
        }
        double callbackRate = this.benchmarkCallbackRate();
        double nonCallbackRate = this.benchmarkNonCallbackRate();
        LOG.info(String.format("AsyncCallback Send rate: %,.2f m/s", callbackRate));
        LOG.info(String.format("NonAsyncCallback Send rate: %,.2f m/s", nonCallbackRate));
        JmsSendWithAsyncCallbackTest.assertTrue((String)("async rate[" + callbackRate + "] should beat non-async rate[" + nonCallbackRate + "]"), (callbackRate / nonCallbackRate > 1.5 ? 1 : 0) != 0);
    }

    private double benchmarkNonCallbackRate() throws JMSException {
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.getName());
        int count = 1000;
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)queue);
        producer.setDeliveryMode(2);
        long start = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            producer.send((Message)session.createTextMessage("Hello"));
        }
        return 1000.0 * (double)count / (double)(System.currentTimeMillis() - start);
    }

    private double benchmarkCallbackRate() throws JMSException, InterruptedException {
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.getName());
        int count = 1000;
        final CountDownLatch messagesSent = new CountDownLatch(count);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)queue);
        producer.setDeliveryMode(2);
        long start = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            producer.send((Message)session.createTextMessage("Hello"), new AsyncCallback(){

                public void onSuccess() {
                    messagesSent.countDown();
                }

                public void onException(JMSException exception) {
                    exception.printStackTrace();
                }
            });
        }
        messagesSent.await();
        return 1000.0 * (double)count / (double)(System.currentTimeMillis() - start);
    }
}

