/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.Message;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.policy.DeadLetterTest;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.DiscardingDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscardingDeadLetterPolicyTest
extends DeadLetterTest {
    private static final Logger LOG = LoggerFactory.getLogger(DiscardingDeadLetterPolicyTest.class);

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        DiscardingDeadLetterStrategy strategy = new DiscardingDeadLetterStrategy();
        strategy.setProcessNonPersistent(true);
        policy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    protected void doTest() throws Exception {
        int i;
        this.connection.start();
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.connection;
        this.rollbackCount = amqConnection.getRedeliveryPolicy().getMaximumRedeliveries() + 1;
        LOG.info("Will redeliver messages: " + this.rollbackCount + " times");
        this.makeConsumer();
        this.makeDlqConsumer();
        this.sendMessages();
        for (i = 0; i < this.messageCount; ++i) {
            this.consumeAndRollback(i);
        }
        for (i = 0; i < this.messageCount; ++i) {
            Message msg = this.dlqConsumer.receive(1000L);
            DiscardingDeadLetterPolicyTest.assertNull((String)("Should not be a DLQ message for loop: " + i), (Object)msg);
        }
        this.session.commit();
    }
}

