/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.List;
import javax.management.openmbean.TabularData;
import org.apache.activemq.broker.jmx.JobSchedulerViewMBean;
import org.apache.activemq.broker.scheduler.JobSchedulerTestSupport;
import org.apache.activemq.broker.scheduler.JobSupport;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerJmxManagementTests
extends JobSchedulerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerJmxManagementTests.class);

    @Test
    public void testJobSchedulerMBeanIsRegistered() throws Exception {
        JobSchedulerViewMBean view = this.getJobSchedulerMBean();
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)view.getAllJobs().isEmpty());
    }

    @Test
    public void testGetNumberOfJobs() throws Exception {
        JobSchedulerViewMBean view = this.getJobSchedulerMBean();
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)view.getAllJobs().isEmpty());
        this.scheduleMessage(60000, 0, 0);
        Assert.assertFalse((boolean)view.getAllJobs().isEmpty());
        Assert.assertEquals((long)1L, (long)view.getAllJobs().size());
        this.scheduleMessage(60000, 0, 0);
        Assert.assertEquals((long)2L, (long)view.getAllJobs().size());
    }

    @Test
    public void testRemvoeJob() throws Exception {
        JobSchedulerViewMBean view = this.getJobSchedulerMBean();
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)view.getAllJobs().isEmpty());
        this.scheduleMessage(60000, 0, 0);
        Assert.assertFalse((boolean)view.getAllJobs().isEmpty());
        TabularData jobs = view.getAllJobs();
        Assert.assertEquals((long)1L, (long)jobs.size());
        for (Object key : jobs.keySet()) {
            String jobId = ((List)key).get(0).toString();
            LOG.info("Attempting to remove Job: {}", (Object)jobId);
            view.removeJob(jobId);
        }
        Assert.assertTrue((boolean)view.getAllJobs().isEmpty());
    }

    @Test
    public void testRemvoeJobInRange() throws Exception {
        JobSchedulerViewMBean view = this.getJobSchedulerMBean();
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)view.getAllJobs().isEmpty());
        this.scheduleMessage(60000, 0, 0);
        Assert.assertFalse((boolean)view.getAllJobs().isEmpty());
        String now = JobSupport.getDateTime((long)System.currentTimeMillis());
        String later = JobSupport.getDateTime((long)(System.currentTimeMillis() + 120000L));
        view.removeAllJobs(now, later);
        Assert.assertTrue((boolean)view.getAllJobs().isEmpty());
    }

    @Test
    public void testGetNextScheduledJob() throws Exception {
        JobSchedulerViewMBean view = this.getJobSchedulerMBean();
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)view.getAllJobs().isEmpty());
        this.scheduleMessage(60000, 0, 0);
        Assert.assertFalse((boolean)view.getAllJobs().isEmpty());
        long before = System.currentTimeMillis() + 57000L;
        long toLate = System.currentTimeMillis() + 63000L;
        String next = view.getNextScheduleTime();
        long nextTime = JobSupport.getDataTime((String)next);
        LOG.info("Next Scheduled Time: {} should be after: {}", (Object)next, (Object)JobSupport.getDateTime((long)before));
        Assert.assertTrue((nextTime > before ? 1 : 0) != 0);
        Assert.assertTrue((nextTime < toLate ? 1 : 0) != 0);
    }

    @Test
    public void testGetExecutionCount() throws Exception {
        final JobSchedulerViewMBean view = this.getJobSchedulerMBean();
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)view.getAllJobs().isEmpty());
        this.scheduleMessage(10000, 1000, 10);
        Assert.assertFalse((boolean)view.getAllJobs().isEmpty());
        TabularData jobs = view.getAllJobs();
        Assert.assertEquals((long)1L, (long)jobs.size());
        String jobId = null;
        for (Object key : jobs.keySet()) {
            jobId = ((List)key).get(0).toString();
        }
        final String fixedJobId = jobId;
        LOG.info("Attempting to get execution count for Job: {}", jobId);
        Assert.assertEquals((long)0L, (long)view.getExecutionCount(jobId));
        Assert.assertTrue((String)"Should execute again", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return view.getExecutionCount(fixedJobId) > 0;
            }
        }));
    }

    @Override
    protected boolean isUseJmx() {
        return true;
    }

    protected void scheduleMessage(int time, int period, int repeat) throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage("test msg");
        message.setLongProperty("AMQ_SCHEDULED_DELAY", (long)time);
        message.setLongProperty("AMQ_SCHEDULED_PERIOD", (long)period);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", repeat);
        producer.send((Message)message);
        connection.close();
    }
}

