/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3567Test {
    private static Logger logger = LoggerFactory.getLogger(AMQ3567Test.class);
    private ActiveMQConnectionFactory factory;
    private Connection connection;
    private Session sessionWithListener;
    private Session session;
    private Queue destination;
    private MessageConsumer consumer;
    private Thread thread;
    private BrokerService broker;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        this.startBroker();
        this.initializeConsumer();
        this.startConsumer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runTest() throws Exception {
        this.produceSingleMessage();
        final org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)org.apache.logging.log4j.core.Logger.class.cast(LogManager.getLogger((String)"org.apache.activemq.util.ServiceSupport"));
        final AtomicBoolean failed = new AtomicBoolean(false);
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                InterruptedException ie;
                if (event.getThrown() != null && event.getThrown() instanceof InterruptedException && (ie = (InterruptedException)event.getThrown()).getMessage().startsWith("Could not stop service:")) {
                    logger.info("Received an interrupted exception : ", (Throwable)ie);
                    failed.set(true);
                }
            }
        };
        appender.start();
        Level level = logger.getLevel();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        logger.setLevel(Level.DEBUG);
        try {
            this.stopConsumer();
            this.stopBroker();
            if (failed.get()) {
                Assert.fail((String)"An Interrupt exception was generated");
            }
        }
        finally {
            logger.setLevel(level);
            logger.removeAppender((Appender)appender);
        }
    }

    private void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target/data");
        this.connectionUri = this.broker.addConnector("tcp://localhost:0?wireFormat.maxInactivityDuration=30000&transport.closeAsync=false&transport.threadName&soTimeout=60000&transport.keepAlive=false&transport.useInactivityMonitor=false").getPublishableConnectString();
        this.broker.start(true);
        this.broker.waitUntilStarted();
    }

    private void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    private void initializeConsumer() throws JMSException {
        logger.info("Initializing the consumer messagor that will just not do anything....");
        this.factory = new ActiveMQConnectionFactory();
        this.factory.setBrokerURL("failover:(" + this.connectionUri + "?wireFormat.maxInactivityDuration=30000&keepAlive=true&soTimeout=60000)?jms.watchTopicAdvisories=false&jms.useAsyncSend=false&jms.dispatchAsync=true&jms.producerWindowSize=10485760&jms.copyMessageOnSend=false&jms.disableTimeStampsByDefault=true&InitialReconnectDelay=1000&maxReconnectDelay=10000&maxReconnectAttempts=400&useExponentialBackOff=true");
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.sessionWithListener = this.connection.createSession(false, 1);
        this.session = this.connection.createSession(false, 1);
        this.destination = this.sessionWithListener.createQueue("EMPTY.QUEUE");
    }

    private void startConsumer() throws Exception {
        logger.info("Starting the consumer");
        this.consumer = this.sessionWithListener.createConsumer((Destination)this.destination);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                logger.info("Received a message: " + message);
            }
        });
        this.thread = new Thread(new Runnable(){
            private Session session;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AMQ3567Test.this.destination = this.session.createQueue("EMPTY.QUEUE");
                    MessageConsumer consumer = this.session.createConsumer((Destination)AMQ3567Test.this.destination);
                    for (int cnt = 0; cnt < 2; ++cnt) {
                        Message message = consumer.receive(50000L);
                        logger.info("Received message: " + message);
                    }
                }
                catch (JMSException e) {
                    logger.debug("Received an exception while processing messages", (Throwable)e);
                }
                finally {
                    try {
                        this.session.close();
                    }
                    catch (JMSException e) {
                        logger.debug("Received an exception while closing session", (Throwable)e);
                    }
                }
            }

            public Runnable setSession(Session session) {
                this.session = session;
                return this;
            }
        }.setSession(this.session)){
            {
                this.start();
            }
        };
    }

    private void stopConsumer() throws JMSException {
        logger.info("Stopping the consumer");
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            logger.debug("Received an exception while waiting for thread to complete", (Throwable)e);
        }
        if (this.sessionWithListener != null) {
            this.sessionWithListener.close();
        }
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    private void produceSingleMessage() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(this.connectionUri);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("EMPTY.QUEUE");
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)session.createTextMessage("Single Message"));
        producer.close();
        session.close();
        connection.close();
    }
}

