/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import java.io.Serializable;

public class MessageSender {
    private MessageProducer producer;
    private Session session;

    public MessageSender(String queueName, Connection connection, boolean useTransactedSession, boolean topic) throws Exception {
        this.session = useTransactedSession ? connection.createSession(true, 0) : connection.createSession(false, 1);
        this.producer = this.session.createProducer((Destination)(topic ? this.session.createTopic(queueName) : this.session.createQueue(queueName)));
    }

    public void send(String payload) throws Exception {
        ObjectMessage message = this.session.createObjectMessage();
        message.setObject((Serializable)((Object)payload));
        this.producer.send((Message)message);
        if (this.session.getTransacted()) {
            this.session.commit();
        }
    }

    public MessageProducer getProducer() {
        return this.producer;
    }
}

