/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.kahadb.plist.PListStoreImpl;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.StoreUsage;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.TempUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempStorageBlockedBrokerTest
extends TestSupport {
    public int deliveryMode = 2;
    private static final Logger LOG = LoggerFactory.getLogger(TempStorageBlockedBrokerTest.class);
    private static final int MESSAGES_COUNT = 1000;
    private static byte[] buf = new byte[4096];
    private BrokerService broker;
    AtomicInteger messagesSent = new AtomicInteger(0);
    AtomicInteger messagesConsumed = new AtomicInteger(0);
    protected long messageReceiveTimeout = 10000L;
    Destination destination = new ActiveMQTopic("FooTwo");
    private String connectionUri;

    public void testRunProducerWithHungConsumer() throws Exception {
        long origTempUsage = this.broker.getSystemUsage().getTempUsage().getUsage();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQPrefetchPolicy prefetch = new ActiveMQPrefetchPolicy();
        prefetch.setTopicPrefetch(10);
        factory.setPrefetchPolicy(prefetch);
        Connection consumerConnection = factory.createConnection();
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(false, 1);
        MessageConsumer consumer = consumerSession.createConsumer(this.destination);
        final Connection producerConnection = factory.createConnection();
        producerConnection.start();
        final CountDownLatch producerHasSentTenMessages = new CountDownLatch(10);
        Thread producingThread = new Thread("Producing thread"){

            @Override
            public void run() {
                try {
                    Session session = producerConnection.createSession(false, 1);
                    MessageProducer producer = session.createProducer(TempStorageBlockedBrokerTest.this.destination);
                    producer.setDeliveryMode(TempStorageBlockedBrokerTest.this.deliveryMode);
                    for (int idx = 0; idx < 1000; ++idx) {
                        TextMessage message = session.createTextMessage(new String(buf) + idx);
                        producer.send((Message)message);
                        TempStorageBlockedBrokerTest.this.messagesSent.incrementAndGet();
                        producerHasSentTenMessages.countDown();
                        Thread.sleep(10L);
                        if (idx == 0 || idx % 100 != 0) continue;
                        LOG.info("Sent Message " + idx);
                        LOG.info("Temp Store Usage " + TempStorageBlockedBrokerTest.this.broker.getSystemUsage().getTempUsage().getUsage());
                    }
                    producer.close();
                    session.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        producingThread.start();
        TempStorageBlockedBrokerTest.assertTrue((String)"producer has sent 10 in a reasonable time", (boolean)producerHasSentTenMessages.await(30L, TimeUnit.SECONDS));
        int count = 0;
        Message m = null;
        while ((m = consumer.receive(this.messageReceiveTimeout)) != null) {
            if (++count != 0 && count % 10 == 0) {
                LOG.info("Recieved Message (" + count + "):" + m);
            }
            this.messagesConsumed.incrementAndGet();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                LOG.info("error sleeping");
            }
        }
        LOG.info("Connection Timeout: Retrying.. count: " + count);
        while ((m = consumer.receive(this.messageReceiveTimeout)) != null) {
            if (++count != 0 && count % 100 == 0) {
                LOG.info("Recieved Message (" + count + "):" + m);
            }
            this.messagesConsumed.incrementAndGet();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                LOG.info("error sleeping");
            }
        }
        LOG.info("consumer session closing: consumed count: " + count);
        consumerSession.close();
        producingThread.join();
        long tempUsageBySubscription = this.broker.getSystemUsage().getTempUsage().getUsage();
        LOG.info("Orig Usage: " + origTempUsage + ", currentUsage: " + tempUsageBySubscription);
        producerConnection.close();
        consumerConnection.close();
        LOG.info("Subscrition Usage: " + tempUsageBySubscription + ", endUsage: " + this.broker.getSystemUsage().getTempUsage().getUsage());
        ((PListStoreImpl)this.broker.getTempDataStore()).run();
        LOG.info("Subscrition Usage: " + tempUsageBySubscription + ", endUsage: " + this.broker.getSystemUsage().getTempUsage().getUsage());
        TempStorageBlockedBrokerTest.assertEquals((String)("Incorrect number of Messages Sent: " + this.messagesSent.get()), (int)this.messagesSent.get(), (int)1000);
        TempStorageBlockedBrokerTest.assertEquals((String)("Incorrect number of Messages Consumed: " + this.messagesConsumed.get()), (int)this.messagesConsumed.get(), (int)1000);
    }

    public void testFillTempAndConsume() throws Exception {
        this.broker.getSystemUsage().setSendFailIfNoSpace(true);
        this.destination = new ActiveMQQueue("Foo");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQConnection producerConnection = (ActiveMQConnection)factory.createConnection();
        producerConnection.setAlwaysSyncSend(true);
        producerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer(this.destination);
        producer.setDeliveryMode(1);
        try {
            while (true) {
                TextMessage message = session.createTextMessage(new String(buf) + this.messagesSent.toString());
                producer.send((Message)message);
                this.messagesSent.incrementAndGet();
                if (this.messagesSent.get() % 100 != 0) continue;
                LOG.info("Sent Message " + this.messagesSent.get());
                LOG.info("Temp Store Usage " + this.broker.getSystemUsage().getTempUsage().getUsage());
            }
        }
        catch (ResourceAllocationException ex) {
            LOG.info("Got resource exception : " + ex + ", after sent: " + this.messagesSent.get());
            Connection consumerConnection = factory.createConnection();
            consumerConnection.start();
            Session consumerSession = consumerConnection.createSession(false, 1);
            MessageConsumer consumer = consumerSession.createConsumer(this.destination);
            while (consumer.receive(this.messageReceiveTimeout) != null) {
                this.messagesConsumed.incrementAndGet();
                if (this.messagesConsumed.get() % 1000 != 0) continue;
                LOG.info("received Message " + this.messagesConsumed.get());
                LOG.info("Temp Store Usage " + this.broker.getSystemUsage().getTempUsage().getUsage());
            }
            TempStorageBlockedBrokerTest.assertEquals((String)("Incorrect number of Messages Consumed: " + this.messagesConsumed.get()), (int)this.messagesConsumed.get(), (int)this.messagesSent.get());
            return;
        }
    }

    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.setDefaultPersistenceAdapter(this.broker);
        SystemUsage sysUsage = this.broker.getSystemUsage();
        MemoryUsage memUsage = new MemoryUsage();
        memUsage.setLimit(0x100000L);
        StoreUsage storeUsage = new StoreUsage();
        storeUsage.setLimit(0x2600000L);
        TempUsage tmpUsage = new TempUsage();
        tmpUsage.setLimit(0x2600000L);
        PolicyEntry defaultPolicy = new PolicyEntry();
        defaultPolicy.setProducerFlowControl(false);
        defaultPolicy.setMemoryLimit(10240L);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(defaultPolicy);
        sysUsage.setMemoryUsage(memUsage);
        sysUsage.setStoreUsage(storeUsage);
        sysUsage.setTempUsage(tmpUsage);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.setSystemUsage(sysUsage);
        this.broker.addConnector("tcp://localhost:0").setName("Default");
        this.broker.start();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }
}

