/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.DataStructureTestSupport;

public class ActiveMQDestinationTest
extends DataStructureTestSupport {
    public ActiveMQDestination destination;

    public void initCombosForTestDestinationMarshaling() {
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST"), new ActiveMQTempQueue("TEST:1"), new ActiveMQTempTopic("TEST:1"), new ActiveMQTempQueue("TEST"), new ActiveMQTempTopic("TEST"), new ActiveMQQueue("TEST?option=value"), new ActiveMQTopic("TEST?option=value"), new ActiveMQTempQueue("TEST:1?option=value"), new ActiveMQTempTopic("TEST:1?option=value")});
    }

    public void testDestinationMarshaling() throws IOException {
        this.assertBeanMarshalls(this.destination);
    }

    public void initCombosForTestDestinationOptions() {
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST?k1=v1&k2=v2"), new ActiveMQTopic("TEST?k1=v1&k2=v2"), new ActiveMQTempQueue("TEST:1?k1=v1&k2=v2"), new ActiveMQTempTopic("TEST:1?k1=v1&k2=v2")});
    }

    public void testDestinationOptions() throws IOException {
        Map options = this.destination.getOptions();
        ActiveMQDestinationTest.assertNotNull((Object)options);
        ActiveMQDestinationTest.assertEquals((String)"v1", (String)((String)options.get("k1")));
        ActiveMQDestinationTest.assertEquals((String)"v2", (String)((String)options.get("k2")));
    }

    public void testSorting() throws Exception {
        TreeSet<ActiveMQDestination> set = new TreeSet<ActiveMQDestination>();
        ActiveMQDestination[] destinations = new ActiveMQDestination[]{new ActiveMQQueue("A"), new ActiveMQQueue("B"), new ActiveMQTopic("A"), new ActiveMQTopic("B")};
        List<ActiveMQDestination> expected = Arrays.asList(destinations);
        set.addAll(expected);
        ArrayList actual = new ArrayList(set);
        ActiveMQDestinationTest.assertEquals((String)"Sorted order", expected, actual);
    }

    public void testTransformPollymorphic() throws Exception {
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        ActiveMQDestinationTest.assertEquals(ActiveMQDestination.transform((Destination)queue), queue);
        ActiveMQDestinationTest.assertTrue((String)"is a q", (boolean)(ActiveMQDestination.transform((Destination)new CombyDest(null, "Topic")) instanceof ActiveMQTopic));
        ActiveMQDestinationTest.assertTrue((String)"is a q", (boolean)(ActiveMQDestination.transform((Destination)new CombyDest("Q", null)) instanceof ActiveMQQueue));
        try {
            ActiveMQDestination.transform((Destination)new CombyDest(null, null));
            ActiveMQDestinationTest.fail((String)"expect ex as cannot disambiguate");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            ActiveMQDestination.transform((Destination)new CombyDest("Q", "T"));
            ActiveMQDestinationTest.fail((String)"expect ex as cannot disambiguate");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public static Test suite() {
        return ActiveMQDestinationTest.suite(ActiveMQDestinationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ActiveMQDestinationTest.suite());
    }

    public void testEmptyQueueName() {
        try {
            new ActiveMQQueue("");
            ActiveMQDestinationTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyTopicName() {
        try {
            new ActiveMQTopic("");
            ActiveMQDestinationTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    class CombyDest
    implements Queue,
    Topic,
    TemporaryQueue,
    TemporaryTopic {
        private final String qName;
        private final String topicName;

        public CombyDest(String qName, String topicName) {
            this.qName = qName;
            this.topicName = topicName;
        }

        public void delete() throws JMSException {
        }

        public String getTopicName() throws JMSException {
            return this.topicName;
        }

        public String getQueueName() throws JMSException {
            return this.qName;
        }
    }
}

