/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.jms2.ActiveMQJMS2TestBase;
import org.apache.activemq.jms2.ActiveMQJMS2TestSupport;
import org.apache.activemq.jms2.MessageData;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ActiveMQJMS2MessageListenerTest
extends ActiveMQJMS2TestBase {
    private final String destinationName;
    private final String destinationType;
    private final int ackMode;
    private final String messagePayload;

    public ActiveMQJMS2MessageListenerTest(String destinationType, int ackMode) {
        this.destinationName = "AMQ.JMS2.ACKMODE." + Integer.toString(ackMode) + destinationType.toUpperCase();
        this.destinationType = destinationType;
        this.ackMode = ackMode;
        this.messagePayload = "Test message destType: " + destinationType + " ackMode: " + Integer.toString(ackMode);
    }

    @Parameterized.Parameters(name="destinationType={0}, ackMode={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"queue", 4}, {"queue", 1}, {"queue", 2}, {"queue", 3}, {"queue", 0});
    }

    @Test
    public void testMessageListener() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", this.ackMode);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.destinationName);
            Assert.assertNotNull((Object)destination);
            final QueueViewMBean localQueueViewMBean = this.getQueueViewMBean((ActiveMQDestination)destination);
            JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);
            final AtomicInteger receivedMessageCount = new AtomicInteger();
            final AtomicInteger exceptionCount = new AtomicInteger();
            final CountDownLatch countDownLatch = new CountDownLatch(2);
            jmsConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    countDownLatch.countDown();
                    receivedMessageCount.incrementAndGet();
                    try {
                        switch (ActiveMQJMS2MessageListenerTest.this.ackMode) {
                            case 2: {
                                message.acknowledge();
                                break;
                            }
                            case 4: {
                                message.acknowledge();
                                break;
                            }
                        }
                    }
                    catch (JMSException e) {
                        exceptionCount.incrementAndGet();
                    }
                }
            });
            jmsContext.start();
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, "text", this.messagePayload);
            LinkedList<String> sentMessageIds = new LinkedList<String>();
            for (int deliveryMode : Arrays.asList(1, 2)) {
                MessageData sendMessageData = new MessageData();
                sendMessageData.setMessage(message).setDeliveryMode(deliveryMode);
                sentMessageIds.add(ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData));
            }
            switch (this.ackMode) {
                case 0: {
                    Assert.assertEquals((Object)0L, (Object)localQueueViewMBean.getEnqueueCount());
                    jmsContext.commit();
                    Assert.assertEquals((Object)2L, (Object)localQueueViewMBean.getEnqueueCount());
                    break;
                }
                default: {
                    Assert.assertEquals((Object)2L, (Object)localQueueViewMBean.getEnqueueCount());
                }
            }
            countDownLatch.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)2, (Object)receivedMessageCount.get());
            Assert.assertEquals((Object)0, (Object)exceptionCount.get());
            switch (this.ackMode) {
                case 0: {
                    Assert.assertEquals((Object)0L, (Object)localQueueViewMBean.getDequeueCount());
                    jmsContext.commit();
                    break;
                }
            }
            jmsConsumer.close();
            Assert.assertTrue((String)"DequeueCount = 2 and QueueSize = 0 expected", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return localQueueViewMBean.getDequeueCount() == 2L && localQueueViewMBean.getQueueSize() == 0L;
                }
            }, (long)5000L, (long)100L));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

