/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jmx;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLQRetryTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DLQRetryTest.class);
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected String bindAddress;
    protected Connection connection;

    public void testDefaultDLQ() throws Exception {
        String destinationName = "retry.test.default";
        Object objectNameStr = this.broker.getBrokerObjectName().toString();
        objectNameStr = (String)objectNameStr + ",destinationType=Queue,destinationName=ActiveMQ.DLQ";
        this.invokeRetryDLQ(destinationName, (String)objectNameStr);
    }

    public void testIndividualDLQ() throws Exception {
        String destinationName = "retry.test.individual";
        Object objectNameStr = this.broker.getBrokerObjectName().toString();
        objectNameStr = (String)objectNameStr + ",destinationType=Queue,destinationName=DLQ." + destinationName;
        this.invokeRetryDLQ(destinationName, (String)objectNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeRetryDLQ(String destinationName, String mbeanName) throws Exception {
        this.connection = this.connectionFactory.createConnection();
        try {
            this.connection.start();
            Session session = this.connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue(destinationName));
            TextMessage message = session.createTextMessage("Message testing default DLQ");
            producer.send((Message)message);
            producer.close();
            String mesageID = this.consumeRollbackMessage(destinationName);
            ObjectName queueViewMBeanName = this.assertRegisteredObjectName(mbeanName);
            QueueViewMBean DLQProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
            DLQRetryTest.assertEquals((String)"Check message is on DLQ", (long)1L, (long)DLQProxy.getQueueSize());
            boolean moveSuccess = DLQProxy.retryMessage(mesageID);
            DLQRetryTest.assertEquals((String)"moveSuccess", (boolean)true, (boolean)moveSuccess);
            DLQRetryTest.assertEquals((String)"Check message is off DLQ (after retry invoked)", (long)0L, (long)DLQProxy.getQueueSize());
            String mesageID_secondAttempt = this.consumeRollbackMessage(destinationName);
            DLQRetryTest.assertEquals((String)"Ensure messageID is the same for first and second attempt", (String)mesageID, (String)mesageID_secondAttempt);
            DLQRetryTest.assertEquals((String)"Check message is on DLQ for second time", (long)1L, (long)DLQProxy.getQueueSize());
        }
        finally {
            this.connection.close();
        }
    }

    private String consumeRollbackMessage(String destination) throws JMSException {
        Session consumerSession = this.connection.createSession(true, 1);
        MessageConsumer messageConsumer = consumerSession.createConsumer((Destination)new ActiveMQQueue(destination));
        Message message = null;
        String messageID = null;
        do {
            if ((message = messageConsumer.receive(3000L)) == null) continue;
            LOG.info("rolling back " + message.getJMSMessageID());
            messageID = message.getJMSMessageID();
            consumerSession.rollback();
        } while (message != null);
        messageConsumer.close();
        return messageID;
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            LOG.info("Bean Registered: " + objectName);
        } else {
            DLQRetryTest.fail((String)("Could not find MBean!: " + objectName));
        }
        return objectName;
    }

    @Override
    protected void setUp() throws Exception {
        System.setProperty("org.apache.activemq.audit", "all");
        this.bindAddress = "tcp://localhost:0";
        this.useTopic = false;
        super.setUp();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(true);
        answer.setEnableStatistics(true);
        answer.addConnector(this.bindAddress);
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        IndividualDeadLetterStrategy individualDeadLetterStrategy = new IndividualDeadLetterStrategy();
        individualDeadLetterStrategy.setQueuePrefix("DLQ.");
        pe.setDeadLetterStrategy((DeadLetterStrategy)individualDeadLetterStrategy);
        pe.setQueue("retry.test.individual");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        answer.setDestinationPolicy(policyMap);
        ((KahaDBPersistenceAdapter)answer.getPersistenceAdapter()).setConcurrentStoreAndDispatchQueues(false);
        answer.deleteAllMessages();
        return answer;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setMaximumRedeliveries(1);
        activeMQConnectionFactory.setRedeliveryPolicy(redeliveryPolicy);
        return activeMQConnectionFactory;
    }
}

