/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.TemporaryQueue;
import java.lang.reflect.Field;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.network.SimpleNetworkTest;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;

public class DynamicallyIncludedDestinationsDuplexNetworkTest
extends SimpleNetworkTest {
    private static final int REMOTE_BROKER_TCP_PORT = 61617;

    @Override
    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/duplexDynamicIncludedDestLocalBroker.xml";
    }

    @Override
    protected BrokerService createRemoteBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("remoteBroker");
        broker.addConnector("tcp://localhost:61617");
        return broker;
    }

    @Override
    public void testRequestReply() throws Exception {
    }

    @Test
    public void testTempQueues() throws Exception {
        TemporaryQueue temp = this.localSession.createTemporaryQueue();
        MessageProducer producer = this.localSession.createProducer((Destination)temp);
        producer.send((Message)this.localSession.createTextMessage("test"));
        Thread.sleep(100L);
        Assert.assertEquals((String)"Destination not created", (long)1L, (long)this.remoteBroker.getAdminView().getTemporaryQueues().length);
        temp.delete();
        Thread.sleep(100L);
        Assert.assertEquals((String)"Destination not deleted", (long)0L, (long)this.remoteBroker.getAdminView().getTemporaryQueues().length);
    }

    @Test
    public void testDynamicallyIncludedDestinationsForDuplex() throws Exception {
        TransportConnection bridgeConnection = this.getDuplexBridgeConnectionFromRemote();
        Assert.assertNotNull((Object)bridgeConnection);
        DemandForwardingBridge duplexBridge = this.getDuplexBridgeFromConnection(bridgeConnection);
        Assert.assertNotNull((Object)duplexBridge);
        NetworkBridgeConfiguration configuration = this.getConfigurationFromNetworkBridge((DemandForwardingBridgeSupport)duplexBridge);
        Assert.assertNotNull((Object)configuration);
        Assert.assertFalse((String)"This destinationFilter does not include ONLY the destinations specified in dynamicallyIncludedDestinations", (boolean)configuration.getDestinationFilter().equals("ActiveMQ.Advisory.Consumer.>"));
        Assert.assertEquals((String)"There are other patterns in the destinationFilter that shouldn't be there", (Object)"ActiveMQ.Advisory.Consumer.Queue.include.test.foo,ActiveMQ.Advisory.Consumer.Topic.include.test.bar", (Object)configuration.getDestinationFilter());
    }

    private NetworkBridgeConfiguration getConfigurationFromNetworkBridge(DemandForwardingBridgeSupport duplexBridge) throws NoSuchFieldException, IllegalAccessException {
        Field f = DemandForwardingBridgeSupport.class.getDeclaredField("configuration");
        f.setAccessible(true);
        NetworkBridgeConfiguration configuration = (NetworkBridgeConfiguration)f.get(duplexBridge);
        return configuration;
    }

    private DemandForwardingBridge getDuplexBridgeFromConnection(TransportConnection bridgeConnection) throws NoSuchFieldException, IllegalAccessException {
        Field f = TransportConnection.class.getDeclaredField("duplexBridge");
        f.setAccessible(true);
        DemandForwardingBridge bridge = (DemandForwardingBridge)f.get(bridgeConnection);
        return bridge;
    }

    public TransportConnection getDuplexBridgeConnectionFromRemote() {
        TransportConnector transportConnector = this.remoteBroker.getTransportConnectorByScheme("tcp");
        CopyOnWriteArrayList transportConnections = transportConnector.getConnections();
        TransportConnection duplexBridgeConnectionFromRemote = (TransportConnection)transportConnections.get(0);
        return duplexBridgeConnectionFromRemote;
    }

    @Override
    protected void assertNetworkBridgeStatistics(final long expectedLocalSent, final long expectedRemoteSent) throws Exception {
        final NetworkBridge localBridge = (NetworkBridge)((NetworkConnector)this.localBroker.getNetworkConnectors().get(0)).activeBridges().iterator().next();
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return expectedLocalSent == localBridge.getNetworkBridgeStatistics().getDequeues().getCount() && expectedRemoteSent == localBridge.getNetworkBridgeStatistics().getReceivedCount().getCount();
            }
        }));
    }
}

