/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.perf.Consumer;
import org.apache.activemq.perf.Producer;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.apache.xbean.spring.context.ClassPathXmlApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class NetworkedSyncTest
extends TestCase {
    public static final int MESSAGE_COUNT = 10000;
    public static final String config = "org/apache/activemq/perf/networkSync.xml";
    public static final String broker1URL = "tcp://localhost:61616";
    public static final String broker2URL = "tcp://localhost:62616";
    private final String networkConnectorURL = "static://(tcp://localhost:62616)";
    private static final Logger LOG = LoggerFactory.getLogger(NetworkedSyncTest.class);
    BrokerService broker1 = null;
    BrokerService broker2 = null;
    NetworkConnector connector = null;

    public NetworkedSyncTest(String name) {
        super(name);
        LOG.info("Testcase started.");
    }

    public static void main(String[] args) {
        TestRunner.run(NetworkedSyncTest.class);
    }

    protected void setUp() throws Exception {
        LOG.info("setUp() called.");
        ClassPathXmlApplicationContext context1 = null;
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(config));
        NetworkedSyncTest.assertNotNull((Object)brokerFactory);
        try {
            Thread.currentThread().setContextClassLoader(NetworkedSyncTest.class.getClassLoader());
            context1 = new ClassPathXmlApplicationContext(config);
            this.broker1 = (BrokerService)context1.getBean("broker1");
            if (!this.broker1.isStarted()) {
                LOG.info("Broker broker1 not yet started. Kicking it off now.");
                this.broker1.start();
            } else {
                LOG.info("Broker broker1 already started. Not kicking it off a second time.");
                this.broker1.waitUntilStopped();
            }
        }
        catch (Exception e) {
            LOG.error("Error: " + e.getMessage());
            throw e;
        }
        try {
            Thread.currentThread().setContextClassLoader(NetworkedSyncTest.class.getClassLoader());
            context1 = new ClassPathXmlApplicationContext(config);
            this.broker2 = (BrokerService)context1.getBean("broker2");
            if (!this.broker2.isStarted()) {
                LOG.info("Broker broker2 not yet started. Kicking it off now.");
                this.broker2.start();
            } else {
                LOG.info("Broker broker2 already started. Not kicking it off a second time.");
                this.broker2.waitUntilStopped();
            }
        }
        catch (Exception e) {
            LOG.error("Error: " + e.getMessage());
            throw e;
        }
        this.connector = this.broker1.addNetworkConnector("static://(tcp://localhost:62616)");
        this.connector.setBrokerName(this.broker1.getBrokerName());
        this.connector.setDuplex(true);
        this.connector.start();
        LOG.info("Network connector created.");
    }

    protected void tearDown() throws Exception {
        LOG.info("tearDown() called.");
        if (this.broker1 != null && this.broker1.isStarted()) {
            LOG.info("Broker1 still running, stopping it now.");
            this.broker1.stop();
        } else {
            LOG.info("Broker1 not running, nothing to shutdown.");
        }
        if (this.broker2 != null && this.broker2.isStarted()) {
            LOG.info("Broker2 still running, stopping it now.");
            this.broker2.stop();
        } else {
            LOG.info("Broker2 not running, nothing to shutdown.");
        }
    }

    public void testMessageExchange() throws Exception {
        LOG.info("testMessageExchange() called.");
        long start = System.currentTimeMillis();
        Thread producer = new Thread(new Producer());
        Thread consumer = new Thread(new Consumer());
        consumer.start();
        Thread.sleep(2000L);
        producer.start();
        producer.join();
        consumer.join();
        long end = System.currentTimeMillis();
        System.out.println("Duration: " + (end - start));
    }
}

