/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.jaas.CertificateLoginModule;
import org.apache.activemq.jaas.JaasCertificateCallbackHandler;
import org.apache.activemq.jaas.PropertiesLoader;
import org.apache.activemq.jaas.TextFileCertificateLoginModule;
import org.apache.activemq.transport.tcp.StubX509Certificate;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFileCertificateLoginModuleTest {
    private static final String CERT_USERS_FILE_SMALL = "cert-users-SMALL.properties";
    private static final String CERT_USERS_FILE_LARGE = "cert-users-LARGE.properties";
    private static final String CERT_USERS_FILE_REGEXP = "cert-users-REGEXP.properties";
    private static final String CERT_GROUPS_FILE = "cert-groups.properties";
    private static final Logger LOG;
    private static final int NUMBER_SUBJECTS = 10;
    private CertificateLoginModule loginModule;

    @Before
    public void setUp() throws Exception {
        this.loginModule = new TextFileCertificateLoginModule();
    }

    @After
    public void tearDown() throws Exception {
        PropertiesLoader.resetUsersAndGroupsCache();
    }

    @Test
    public void testLoginWithSMALLUsersFile() throws Exception {
        this.loginTest(CERT_USERS_FILE_SMALL, CERT_GROUPS_FILE);
    }

    @Test
    public void testLoginWithLARGEUsersFile() throws Exception {
        this.loginTest(CERT_USERS_FILE_LARGE, CERT_GROUPS_FILE);
    }

    @Test
    public void testLoginWithREGEXPUsersFile() throws Exception {
        this.loginTest(CERT_USERS_FILE_REGEXP, CERT_GROUPS_FILE);
    }

    private void loginTest(String usersFiles, String groupsFile) throws LoginException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.apache.activemq.jaas.textfiledn.user", usersFiles);
        options.put("org.apache.activemq.jaas.textfiledn.group", groupsFile);
        options.put("reload", "true");
        JaasCertificateCallbackHandler[] callbackHandlers = new JaasCertificateCallbackHandler[10];
        Subject[] subjects = new Subject[10];
        for (int i = 0; i < callbackHandlers.length; ++i) {
            callbackHandlers[i] = this.getJaasCertificateCallbackHandler("DN=TEST_USER_" + (i + 1));
        }
        long startTime = System.currentTimeMillis();
        for (int outer = 0; outer < 500; ++outer) {
            for (int i = 0; i < 10; ++i) {
                Subject subject;
                subjects[i] = subject = this.doAuthenticate(options, callbackHandlers[i]);
            }
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        for (int i = 0; i < 10; ++i) {
            LOG.info("subject is: " + subjects[i].getPrincipals().toString());
        }
        LOG.info(usersFiles + ": Time taken is " + timeTaken);
    }

    private JaasCertificateCallbackHandler getJaasCertificateCallbackHandler(String user) {
        JMXPrincipal principal = new JMXPrincipal(user);
        StubX509Certificate cert = new StubX509Certificate(principal);
        return new JaasCertificateCallbackHandler(new X509Certificate[]{cert});
    }

    private Subject doAuthenticate(HashMap options, JaasCertificateCallbackHandler callbackHandler) throws LoginException {
        Subject mySubject = new Subject();
        this.loginModule.initialize(mySubject, (CallbackHandler)callbackHandler, null, (Map)options);
        this.loginModule.login();
        this.loginModule.commit();
        return mySubject;
    }

    static {
        URL resource;
        LOG = LoggerFactory.getLogger(TextFileCertificateLoginModuleTest.class);
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = TextFileCertificateLoginModuleTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

