/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MKahaDBIndexLocationTest {
    private static final Logger LOG = LoggerFactory.getLogger(MKahaDBIndexLocationTest.class);
    private BrokerService broker;
    private final File testDataDir = new File("target/activemq-data/ConfigIndexDir");
    private final File kahaDataDir = new File(this.testDataDir, "log");
    private final File kahaIndexDir = new File(this.testDataDir, "index");
    private final ActiveMQQueue queue = new ActiveMQQueue("Qq");

    @Before
    public void startBroker() throws Exception {
        this.createBroker();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    private void createBroker() throws Exception {
        this.broker = new BrokerService();
        MultiKahaDBPersistenceAdapter persistenceAdapter = new MultiKahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(this.kahaDataDir);
        KahaDBPersistenceAdapter kahaStore = new KahaDBPersistenceAdapter();
        kahaStore.setJournalMaxFileLength(524288);
        kahaStore.setIndexDirectory(this.kahaIndexDir);
        FilteredKahaDBPersistenceAdapter filtered = new FilteredKahaDBPersistenceAdapter();
        filtered.setPersistenceAdapter((PersistenceAdapter)kahaStore);
        filtered.setPerDestination(true);
        ArrayList<FilteredKahaDBPersistenceAdapter> stores = new ArrayList<FilteredKahaDBPersistenceAdapter>();
        stores.add(filtered);
        persistenceAdapter.setFilteredPersistenceAdapters(stores);
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.broker.setUseJmx(false);
        this.broker.setAdvisorySupport(false);
        this.broker.setSchedulerSupport(false);
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
    }

    @Test
    public void testIndexDirExists() throws Exception {
        this.produceMessages();
        LOG.info("Index dir is configured as: {}", (Object)this.kahaIndexDir);
        Assert.assertTrue((boolean)this.kahaDataDir.exists());
        Assert.assertTrue((boolean)this.kahaIndexDir.exists());
        String destName = MultiKahaDBPersistenceAdapter.nameFromDestinationFilter((ActiveMQDestination)this.queue);
        String[] index = new File(this.kahaIndexDir, destName).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                LOG.info("Testing index filename: {}", (Object)name);
                return name.endsWith("data") || name.endsWith("redo");
            }
        });
        String[] journal = new File(this.kahaDataDir, destName).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                LOG.info("Testing log filename: {}", (Object)name);
                return name.endsWith("log") || name.equals("lock");
            }
        });
        Assert.assertNotNull((Object)index);
        Assert.assertEquals((long)2L, (long)index.length);
        Assert.assertNotNull((Object)journal);
        Assert.assertEquals((long)1L, (long)journal.length);
        this.stopBroker();
        this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.consume();
    }

    private void consume() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?create=false");
        Connection connection = cf.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        for (int i = 0; i < 5; ++i) {
            Assert.assertNotNull((String)("message[" + i + "]"), (Object)consumer.receive(4000L));
        }
        connection.close();
    }

    private void produceMessages() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?create=false");
        Connection connection = cf.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        for (int i = 0; i < 5; ++i) {
            producer.send((Message)session.createTextMessage("test:" + i));
        }
        connection.close();
    }
}

