/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.net.URI;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;

public class DiscoveryUriTest
extends EmbeddedBrokerTestSupport {
    @Override
    protected BrokerService createBroker() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        BrokerService answer = new BrokerService();
        answer.setPersistent(this.isPersistent());
        TransportConnector connector = new TransportConnector();
        connector.setUri(new URI(this.bindAddress));
        connector.setDiscoveryUri(new URI("multicast://default?group=test"));
        answer.addConnector(connector);
        return answer;
    }

    public void testConnect() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("discovery:(multicast://default?group=test)?reconnectDelay=1000&maxReconnectAttempts=30&useExponentialBackOff=false");
        Connection conn = factory.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        MessageProducer producer = sess.createProducer((Destination)sess.createQueue("test"));
        producer.send((Message)sess.createTextMessage("test"));
        MessageConsumer consumer = sess.createConsumer((Destination)sess.createQueue("test"));
        Message msg = consumer.receive(1000L);
        DiscoveryUriTest.assertNotNull((Object)msg);
    }

    public void testFailedConnect() throws Exception {
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("discovery:(multicast://default?group=test1)?reconnectDelay=1000&startupMaxReconnectAttempts=3&useExponentialBackOff=false");
            Connection conn = factory.createConnection();
            conn.start();
        }
        catch (Exception e) {
            return;
        }
        DiscoveryUriTest.fail((String)"Expected connection failure");
    }
}

