/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.NetworkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverUpdateURIsTest
extends TestCase {
    private static final String QUEUE_NAME = "test.failoverupdateuris";
    private static final Logger LOG = LoggerFactory.getLogger(FailoverUpdateURIsTest.class);
    String firstTcpUri = "tcp://localhost:61616";
    String secondTcpUri = "tcp://localhost:61626";
    Connection connection = null;
    BrokerService bs1 = null;
    BrokerService bs2 = null;

    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.bs1 != null) {
            this.bs1.stop();
        }
        if (this.bs2 != null) {
            this.bs2.stop();
        }
    }

    public void testUpdateURIsViaFile() throws Exception {
        String targetDir = "target/" + this.getName();
        new File(targetDir).mkdir();
        File updateFile = new File(targetDir + "/updateURIsFile.txt");
        LOG.info("updateFile:" + updateFile);
        LOG.info("updateFileUri:" + updateFile.toURI());
        LOG.info("updateFileAbsoluteFile:" + updateFile.getAbsoluteFile());
        LOG.info("updateFileAbsoluteFileUri:" + updateFile.getAbsoluteFile().toURI());
        FileOutputStream out = new FileOutputStream(updateFile);
        out.write(this.firstTcpUri.getBytes());
        out.close();
        this.bs1 = this.createBroker("bs1", this.firstTcpUri);
        this.bs1.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:()?updateURIsURL=file:///" + updateFile.getAbsoluteFile());
        this.connection = cf.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue theQueue = session.createQueue(QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)theQueue);
        MessageConsumer consumer = session.createConsumer((Destination)theQueue);
        TextMessage message = session.createTextMessage("Test message");
        producer.send((Message)message);
        Message msg = consumer.receive(2000L);
        FailoverUpdateURIsTest.assertNotNull((Object)msg);
        this.bs1.stop();
        this.bs1.waitUntilStopped();
        this.bs1 = null;
        this.bs2 = this.createBroker("bs2", this.secondTcpUri);
        this.bs2.start();
        out = new FileOutputStream(updateFile, true);
        out.write(",".getBytes());
        out.write(this.secondTcpUri.toString().getBytes());
        out.close();
        producer.send((Message)message);
        msg = consumer.receive(2000L);
        FailoverUpdateURIsTest.assertNotNull((Object)msg);
    }

    private BrokerService createBroker(String name, String tcpUri) throws Exception {
        BrokerService bs = new BrokerService();
        bs.setBrokerName(name);
        bs.setUseJmx(false);
        bs.setPersistent(false);
        bs.addConnector(tcpUri);
        return bs;
    }

    public void testAutoUpdateURIs() throws Exception {
        this.bs1 = new BrokerService();
        this.bs1.setUseJmx(false);
        TransportConnector transportConnector = this.bs1.addConnector(this.firstTcpUri);
        transportConnector.setUpdateClusterClients(true);
        this.bs1.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.firstTcpUri + ")");
        this.connection = cf.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue theQueue = session.createQueue(QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)theQueue);
        MessageConsumer consumer = session.createConsumer((Destination)theQueue);
        TextMessage message = session.createTextMessage("Test message");
        producer.send((Message)message);
        Message msg = consumer.receive(4000L);
        FailoverUpdateURIsTest.assertNotNull((Object)msg);
        this.bs2 = this.createBroker("bs2", this.secondTcpUri);
        NetworkConnector networkConnector = this.bs2.addNetworkConnector("static:(" + this.firstTcpUri + ")");
        networkConnector.setDuplex(true);
        this.bs2.start();
        LOG.info("started brokerService 2");
        this.bs2.waitUntilStarted();
        TimeUnit.SECONDS.sleep(4L);
        LOG.info("stopping brokerService 1");
        this.bs1.stop();
        this.bs1.waitUntilStopped();
        this.bs1 = null;
        producer.send((Message)message);
        msg = consumer.receive(4000L);
        FailoverUpdateURIsTest.assertNotNull((Object)msg);
    }
}

