/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;

public class CreateTemporaryQueueBeforeStartTest
extends TestCase {
    private final String bindAddress = "tcp://localhost:0";
    private String connectionUri;
    private Connection connection;
    private BrokerService broker = new BrokerService();

    public void testCreateTemporaryQueue() throws Exception {
        this.connection = this.createConnection();
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        CreateTemporaryQueueBeforeStartTest.assertTrue((String)"No queue created!", (queue != null ? 1 : 0) != 0);
        TemporaryTopic topic = session.createTemporaryTopic();
        CreateTemporaryQueueBeforeStartTest.assertTrue((String)"No topic created!", (topic != null ? 1 : 0) != 0);
    }

    public void testTryToReproduceNullPointerBug() throws Exception {
        String url = this.connectionUri;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(url);
        QueueConnection queueConnection = factory.createQueueConnection();
        this.connection = queueConnection;
        QueueSession session = queueConnection.createQueueSession(false, 1);
        session.createSender(null);
        TemporaryQueue receiverQueue = session.createTemporaryQueue();
        session.createReceiver((Queue)receiverQueue);
        queueConnection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTemporaryQueueConsumer() throws Exception {
        int number = 20;
        final AtomicInteger count = new AtomicInteger(0);
        for (int i = 0; i < 20; ++i) {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block5: {
                        try {
                            QueueConnection connection = CreateTemporaryQueueBeforeStartTest.this.createConnection();
                            QueueSession session = connection.createQueueSession(false, 1);
                            TemporaryQueue queue = session.createTemporaryQueue();
                            session.createReceiver((Queue)queue);
                            connection.start();
                            if (count.incrementAndGet() < 20) break block5;
                            AtomicInteger atomicInteger = count;
                            synchronized (atomicInteger) {
                                count.notify();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            thread.start();
        }
        int maxWaitTime = 20000;
        AtomicInteger atomicInteger = count;
        synchronized (atomicInteger) {
            long waitTime = maxWaitTime;
            long start = System.currentTimeMillis();
            while (count.get() < 20 && waitTime > 0L) {
                count.wait(waitTime);
                waitTime = (long)maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
        CreateTemporaryQueueBeforeStartTest.assertTrue((String)("Unexpected count: " + count), (count.get() == 20 ? 1 : 0) != 0);
    }

    protected QueueConnection createConnection() throws Exception {
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        return factory.createQueueConnection();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    protected void setUp() throws Exception {
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.connectionUri = this.broker.addConnector("tcp://localhost:0").getPublishableConnectString();
        this.broker.start();
        this.broker.waitUntilStarted();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.broker.stop();
        super.tearDown();
    }
}

