/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.JMSException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslBrokerService;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public class ActiveMQSslConnectionFactoryTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(ActiveMQSslConnectionFactoryTest.class);
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private ActiveMQConnection connection;
    private BrokerService broker;

    protected void tearDown() throws Exception {
        try {
            this.connection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.broker.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testCreateTcpConnectionUsingKnownPort() throws Exception {
        this.broker = this.createBroker("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
        ActiveMQSslConnectionFactory cf = this.getFactory("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testCreateTcpConnectionWithSocketParameters() throws Exception {
        String tcpUri = "tcp://localhost:61610?socket.OOBInline=true&socket.keepAlive=true&tcpNoDelay=true";
        this.broker = this.createBroker(tcpUri);
        ActiveMQSslConnectionFactory cf = this.getFactory(tcpUri);
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        Socket socket = this.getSocketFromConnection(this.connection);
        ActiveMQSslConnectionFactoryTest.assertTrue((boolean)socket.getOOBInline());
        ActiveMQSslConnectionFactoryTest.assertTrue((boolean)socket.getKeepAlive());
        ActiveMQSslConnectionFactoryTest.assertTrue((boolean)socket.getTcpNoDelay());
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testCreateFailoverTcpConnectionUsingKnownPort() throws Exception {
        this.broker = this.createBroker("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
        ActiveMQSslConnectionFactory cf = this.getFactory("failover:(tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true)");
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testCreateSslConnection() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory(sslUri);
        cf.setTrustStore("server.keystore");
        cf.setTrustStorePassword(PASSWORD);
        this.connection = (ActiveMQConnection)cf.createConnection();
        LOG.info((Object)"Created client connection");
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testCreateSslConnectionWithSocketParameters() throws Exception {
        String sslUri = "ssl://localhost:61611?socket.enabledProtocols=TLSv1.3&socket.enableSessionCreation=true&socket.needClientAuth=true";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory(sslUri);
        cf.setTrustStore("server.keystore");
        cf.setTrustStorePassword(PASSWORD);
        this.connection = (ActiveMQConnection)cf.createConnection();
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        SSLSocket socket = (SSLSocket)this.getSocketFromConnection(this.connection);
        Object[] expectedProtocols = new String[]{"TLSv1.3"};
        Assert.assertArrayEquals((Object[])expectedProtocols, (Object[])socket.getEnabledProtocols());
        ActiveMQSslConnectionFactoryTest.assertTrue((boolean)socket.getEnableSessionCreation());
        ActiveMQSslConnectionFactoryTest.assertTrue((boolean)socket.getNeedClientAuth());
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testCreateSslConnectionKeyStore() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory(sslUri);
        cf.setKeyStore("server.keystore");
        cf.setKeyStorePassword(PASSWORD);
        cf.setTrustStore("server.keystore");
        cf.setTrustStorePassword(PASSWORD);
        this.connection = (ActiveMQConnection)cf.createConnection();
        LOG.info((Object)"Created client connection");
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testFailoverSslConnection() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory("failover:(" + sslUri + ")?maxReconnectAttempts=4");
        cf.setTrustStore("server.keystore");
        cf.setTrustStorePassword(PASSWORD);
        this.connection = (ActiveMQConnection)cf.createConnection();
        LOG.info((Object)"Created client connection");
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testFailoverSslConnectionWithKeyAndTrustManagers() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory("failover:(" + sslUri + ")?maxReconnectAttempts=4");
        cf.setKeyAndTrustManagers(ActiveMQSslConnectionFactoryTest.getKeyManager(), ActiveMQSslConnectionFactoryTest.getTrustManager(), new SecureRandom());
        this.connection = (ActiveMQConnection)cf.createConnection();
        LOG.info((Object)"Created client connection");
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testNegativeCreateSslConnectionWithWrongTrustStorePassword() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory(sslUri);
        cf.setTrustStore("server.keystore");
        cf.setTrustStorePassword("wrongPassword");
        try {
            this.connection = (ActiveMQConnection)cf.createConnection();
        }
        catch (JMSException ignore) {
            ActiveMQSslConnectionFactoryTest.assertTrue((boolean)(ActiveMQSslConnectionFactoryTest.getRootCause(ignore) instanceof UnrecoverableKeyException));
            LOG.info((Object)("Expected java.io.Exception [" + String.valueOf((Object)ignore) + "]"));
        }
        ActiveMQSslConnectionFactoryTest.assertNull((Object)this.connection);
        this.brokerStop();
    }

    public void testCreateSslConnectionWithNullTrustStorePassword() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory(sslUri);
        cf.setTrustStore("server.keystore");
        this.connection = (ActiveMQConnection)cf.createConnection();
        LOG.info((Object)"Created client connection");
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.connection.stop();
        this.brokerStop();
    }

    public void testNegativeCreateSslConnectionWithWrongKeyStorePassword() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory(sslUri);
        cf.setKeyStore("server.keystore");
        cf.setKeyStorePassword("badPassword");
        cf.setTrustStore("server.keystore");
        cf.setTrustStorePassword(PASSWORD);
        try {
            this.connection = (ActiveMQConnection)cf.createConnection();
        }
        catch (JMSException ignore) {
            ActiveMQSslConnectionFactoryTest.assertTrue((boolean)(ActiveMQSslConnectionFactoryTest.getRootCause(ignore) instanceof UnrecoverableKeyException));
            LOG.info((Object)("Expected java.io.Exception [" + String.valueOf((Object)ignore) + "]"));
        }
        ActiveMQSslConnectionFactoryTest.assertNull((Object)this.connection);
        this.brokerStop();
    }

    public void testNegativeCreateSslConnectionWithNullKeyStorePassword() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory(sslUri);
        cf.setKeyStore("server.keystore");
        cf.setTrustStore("server.keystore");
        cf.setTrustStorePassword(PASSWORD);
        try {
            this.connection = (ActiveMQConnection)cf.createConnection();
        }
        catch (JMSException ignore) {
            ActiveMQSslConnectionFactoryTest.assertTrue((boolean)(ActiveMQSslConnectionFactoryTest.getRootCause(ignore) instanceof UnrecoverableKeyException));
            LOG.info((Object)("Expected java.io.Exception [" + String.valueOf((Object)ignore) + "]"));
        }
        ActiveMQSslConnectionFactoryTest.assertNull((Object)this.connection);
        this.brokerStop();
    }

    public void testNegativeCreateSslConnectionWithWrongCert() throws Exception {
        String sslUri = "ssl://localhost:61611";
        this.broker = this.createSslBroker(sslUri);
        ActiveMQSslConnectionFactoryTest.assertNotNull((Object)this.broker);
        ActiveMQSslConnectionFactory cf = this.getFactory(sslUri);
        cf.setTrustStore("dummy.keystore");
        cf.setTrustStorePassword(PASSWORD);
        try {
            this.connection = (ActiveMQConnection)cf.createConnection();
        }
        catch (JMSException ignore) {
            LOG.info((Object)("Expected SSLHandshakeException [" + String.valueOf((Object)ignore) + "]"));
        }
        ActiveMQSslConnectionFactoryTest.assertNull((Object)this.connection);
        this.brokerStop();
    }

    protected BrokerService createBroker(String uri) throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(false);
        service.addConnector(uri);
        service.start();
        return service;
    }

    protected BrokerService createSslBroker(String uri) throws Exception {
        SslBrokerService service = new SslBrokerService();
        service.setPersistent(false);
        KeyManager[] km = ActiveMQSslConnectionFactoryTest.getKeyManager();
        TrustManager[] tm = ActiveMQSslConnectionFactoryTest.getTrustManager();
        service.addSslConnector(uri, km, tm, null);
        service.start();
        return service;
    }

    protected void brokerStop() throws Exception {
        this.broker.stop();
    }

    protected ActiveMQSslConnectionFactory getFactory(String uri) {
        return new ActiveMQSslConnectionFactory(uri);
    }

    public static TrustManager[] getTrustManager() throws Exception {
        TrustManager[] trustStoreManagers = null;
        KeyStore trustedCertStore = KeyStore.getInstance(KEYSTORE_TYPE);
        trustedCertStore.load(new FileInputStream(TRUST_KEYSTORE), null);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustedCertStore);
        trustStoreManagers = tmf.getTrustManagers();
        return trustStoreManagers;
    }

    public static KeyManager[] getKeyManager() throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
        KeyManager[] keystoreManagers = null;
        byte[] sslCert = ActiveMQSslConnectionFactoryTest.loadClientCredential(SERVER_KEYSTORE);
        if (sslCert != null && sslCert.length > 0) {
            ByteArrayInputStream bin = new ByteArrayInputStream(sslCert);
            ks.load(bin, PASSWORD.toCharArray());
            kmf.init(ks, PASSWORD.toCharArray());
            keystoreManagers = kmf.getKeyManagers();
        }
        return keystoreManagers;
    }

    private static byte[] loadClientCredential(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int i = in.read(buf);
        while (i > 0) {
            out.write(buf, 0, i);
            i = in.read(buf);
        }
        in.close();
        return out.toByteArray();
    }

    private static Throwable getRootCause(Throwable throwable) {
        Throwable rootCause = null;
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    private Socket getSocketFromConnection(ActiveMQConnection connection) throws Exception {
        Transport transport = connection.getTransport();
        while (!(transport instanceof TcpTransport)) {
            transport = ((TransportFilter)transport).getNext();
        }
        Class<?> transportClass = transport.getClass();
        if (transport instanceof SslTransport) {
            transportClass = transportClass.getSuperclass();
        }
        Field socket = transportClass.getDeclaredField("socket");
        socket.setAccessible(true);
        return (Socket)socket.get(transport);
    }
}

