/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.test.JmsTopicSendReceiveTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsDurableTopicSendReceiveTest
extends JmsTopicSendReceiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(JmsDurableTopicSendReceiveTest.class);
    protected Connection connection2;
    protected Session session2;
    protected Session consumeSession2;
    protected MessageConsumer consumer2;
    protected MessageProducer producer2;
    protected Destination consumerDestination2;
    protected Destination producerDestination2;

    @Override
    protected void setUp() throws Exception {
        this.durable = true;
        super.setUp();
    }

    public void testSendWhileClosed() throws Exception {
        this.connection2 = this.createConnection();
        this.connection2.setClientID("test");
        this.connection2.start();
        this.session2 = this.connection2.createSession(false, 1);
        this.producer2 = this.session2.createProducer(null);
        this.producer2.setDeliveryMode(this.deliveryMode);
        this.producerDestination2 = this.session2.createTopic(this.getProducerSubject() + "2");
        Thread.sleep(1000L);
        this.consumeSession2 = this.connection2.createSession(false, 1);
        this.consumerDestination2 = this.session2.createTopic(this.getConsumerSubject() + "2");
        this.consumer2 = this.consumeSession2.createDurableSubscriber((Topic)this.consumerDestination2, this.getName());
        Thread.sleep(1000L);
        this.consumer2.close();
        TextMessage message = this.session2.createTextMessage("test");
        message.setStringProperty("test", "test");
        message.setJMSType("test");
        this.producer2.send(this.producerDestination2, (Message)message);
        LOG.info("Creating durable consumer");
        this.consumer2 = this.consumeSession2.createDurableSubscriber((Topic)this.consumerDestination2, this.getName());
        Message msg = this.consumer2.receive(1000L);
        JmsDurableTopicSendReceiveTest.assertNotNull((Object)msg);
        JmsDurableTopicSendReceiveTest.assertEquals((String)((TextMessage)msg).getText(), (String)"test");
        JmsDurableTopicSendReceiveTest.assertEquals((String)msg.getJMSType(), (String)"test");
        JmsDurableTopicSendReceiveTest.assertEquals((String)msg.getStringProperty("test"), (String)"test");
        this.connection2.stop();
        this.connection2.close();
    }
}

