/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsQueueSendReceiveTwoConnectionsTest;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsQueueSendReceiveTwoConnectionsStartBeforeBrokerTest
extends JmsQueueSendReceiveTwoConnectionsTest {
    private static final Logger LOG = LoggerFactory.getLogger(JmsQueueSendReceiveTwoConnectionsStartBeforeBrokerTest.class);
    private Queue<Exception> errors = new ConcurrentLinkedQueue<Exception>();
    private int delayBeforeStartingBroker = 1000;
    private BrokerService broker;

    public void startBroker() {
        LOG.info("Lets wait: " + this.delayBeforeStartingBroker + " millis  before creating the broker");
        try {
            Thread.sleep(this.delayBeforeStartingBroker);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LOG.info("Now starting the broker");
        try {
            this.broker = new BrokerService();
            this.broker.setPersistent(false);
            this.broker.addConnector("tcp://localhost:61616");
            this.broker.start();
        }
        catch (Exception e) {
            LOG.info("Caught: " + String.valueOf(e));
            this.errors.add(e);
        }
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("failover:(tcp://localhost:61616)?maxReconnectAttempts=10&useExponentialBackOff=false&initialReconnectDelay=200");
    }

    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        Thread thread = new Thread(){

            @Override
            public void run() {
                JmsQueueSendReceiveTwoConnectionsStartBeforeBrokerTest.this.startBroker();
            }
        };
        thread.start();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
        if (!this.errors.isEmpty()) {
            Exception e = this.errors.remove();
            throw e;
        }
    }
}

