/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Topic;
import org.apache.activemq.test.JmsTopicSendReceiveTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsQueueTopicCompositeSendReceiveTest
extends JmsTopicSendReceiveTest {
    private static final Log LOG = LogFactory.getLog(JmsQueueTopicCompositeSendReceiveTest.class);
    Destination consumerDestination2;
    MessageConsumer consumer2;

    @Override
    protected void setUp() throws Exception {
        this.deliveryMode = 1;
        this.topic = false;
        super.setUp();
        this.consumerDestination2 = this.consumeSession.createTopic("FOO.BAR.HUMBUG2");
        LOG.info((Object)("Created  consumer destination: " + String.valueOf(this.consumerDestination2) + " of type: " + String.valueOf(this.consumerDestination2.getClass())));
        if (this.durable) {
            LOG.info((Object)"Creating durable consumer");
            this.consumer2 = this.consumeSession.createDurableSubscriber((Topic)this.consumerDestination2, this.getName());
        } else {
            this.consumer2 = this.consumeSession.createConsumer(this.consumerDestination2);
        }
    }

    @Override
    protected String getConsumerSubject() {
        return "FOO.BAR.HUMBUG";
    }

    @Override
    protected String getProducerSubject() {
        return "queue://FOO.BAR.HUMBUG,topic://FOO.BAR.HUMBUG2";
    }

    @Override
    public void testSendReceive() throws Exception {
        super.testSendReceive();
        this.messages.clear();
        this.consumer2.setMessageListener((MessageListener)this);
        this.assertMessagesAreReceived();
        LOG.info((Object)(this.data.length + " messages(s) received, closing down connections"));
    }
}

