/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerDestinationStoreLimitTest
extends JmsTestSupport {
    static final Logger LOG = LoggerFactory.getLogger(PerDestinationStoreLimitTest.class);
    final String oneKb = new String(new byte[1024]);
    ActiveMQDestination queueDest = new ActiveMQQueue("PerDestinationStoreLimitTest.Queue");
    ActiveMQDestination topicDest = new ActiveMQTopic("PerDestinationStoreLimitTest.Topic");
    protected TransportConnector connector;
    protected ActiveMQConnection connection;

    public void testDLQAfterBlockTopic() throws Exception {
        this.doTestDLQAfterBlock(this.topicDest);
    }

    public void testDLQAfterBlockQueue() throws Exception {
        this.doTestDLQAfterBlock(this.queueDest);
    }

    public void doTestDLQAfterBlock(ActiveMQDestination destination) throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setMaximumRedeliveries(0);
        factory.setRedeliveryPolicy(redeliveryPolicy);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.setClientID("someId");
        this.connection.start();
        Session consumerSession = this.connection.createSession(true, 0);
        MessageConsumer consumer = destination.isQueue() ? consumerSession.createConsumer((Destination)destination) : consumerSession.createDurableSubscriber((Topic)destination, "Durable");
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        final Session session = this.connection.createSession(true, 0);
        final MessageProducer producer = session.createProducer((Destination)destination);
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        final CountDownLatch fillerStarted = new CountDownLatch(1);
        final AtomicLong sent = new AtomicLong(0L);
        Thread thread = new Thread("Filler"){
            int i;

            @Override
            public void run() {
                while (keepGoing.get()) {
                    done.set(false);
                    fillerStarted.countDown();
                    try {
                        producer.send((Message)session.createTextMessage(PerDestinationStoreLimitTest.this.oneKb + ++this.i));
                        if (this.i % 10 == 0) {
                            session.commit();
                            sent.getAndAdd(10L);
                            LOG.info("committed/sent: " + sent.get());
                        }
                        LOG.info("sent: " + this.i);
                    }
                    catch (JMSException jMSException) {}
                }
            }
        };
        thread.start();
        PerDestinationStoreLimitTest.assertTrue((String)"filler started..", (boolean)fillerStarted.await(20L, TimeUnit.SECONDS));
        this.waitForBlocked(done);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        int received = 0;
        while ((long)received < sent.get()) {
            TextMessage msg = (TextMessage)consumer.receive(4000L);
            if (msg == null) {
                LOG.info("received null on count: " + received);
                break;
            }
            LOG.info("received: " + received + ", msg: " + msg.getJMSMessageID());
            if (received % 5 == 0) {
                if (received % 3 == 0) {
                    LOG.info("rollback on : " + received);
                    consumerSession.rollback();
                } else {
                    LOG.info("commit on : " + received);
                    consumerSession.commit();
                }
            }
            ++received;
        }
        LOG.info("Done:: sent: " + sent.get() + ", received: " + received);
        keepGoing.set(false);
        PerDestinationStoreLimitTest.assertTrue((String)"some were sent:", (sent.get() > 0L ? 1 : 0) != 0);
        PerDestinationStoreLimitTest.assertEquals((String)"received what was committed", (long)sent.get(), (long)received);
    }

    protected void waitForBlocked(AtomicBoolean done) throws InterruptedException {
        while (true) {
            Thread.sleep(1000L);
            if (done.get()) break;
            done.set(true);
        }
        LOG.info("Blocked....");
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setDeleteAllMessagesOnStartup(true);
        service.setUseJmx(false);
        service.getSystemUsage().getStoreUsage().setLimit(204800L);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setStoreUsageHighWaterMark(50);
        policyMap.put(this.queueDest, (Object)policy);
        policyMap.put(this.topicDest, (Object)policy);
        service.setDestinationPolicy(policyMap);
        this.connector = service.addConnector("tcp://localhost:0");
        return service;
    }

    @Override
    public void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            TcpTransport t = (TcpTransport)this.connection.getTransport().narrow(TcpTransport.class);
            t.getTransportListener().onException(new IOException("Disposed."));
            this.connection.getTransport().stop();
            super.tearDown();
        }
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connector.getConnectUri());
    }
}

