/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JmxOpPageInOnMemoryLimitTest {
    BrokerService broker;
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected Connection connection;
    protected int messageCount = 4000;
    ActiveMQQueue destination = new ActiveMQQueue("QUEUE_TO_FILL_PAST_MEM_LIMIT");
    String lastMessageId = "";

    @Test(timeout=60000L)
    public void testNoHangOnPageInForJmxOps() throws Exception {
        Object objectNameStr = this.broker.getBrokerObjectName().toString();
        objectNameStr = (String)objectNameStr + ",destinationType=Queue,destinationName=" + this.destination.getQueueName();
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName((String)objectNameStr);
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        Assert.assertFalse((String)"limit reached, cache disabled", (boolean)proxy.isCacheEnabled());
        proxy.removeMessage(this.lastMessageId);
        proxy.copyMessageTo(this.lastMessageId, "someOtherQ");
        proxy.moveMatchingMessagesTo("JMSMessageID = '" + this.lastMessageId + "'", "someOtherQ");
        proxy.setDLQ(true);
        proxy.retryMessages();
        try {
            proxy.retryMessage(this.lastMessageId);
        }
        catch (JMSException expected) {
            Assert.assertTrue((String)"Could not find", (boolean)expected.getMessage().contains("find"));
        }
        long count = proxy.getQueueSize();
        boolean cursorFull = proxy.getCursorPercentUsage() >= 70;
        Assert.assertTrue((String)"Cursor full", (boolean)cursorFull);
        Assert.assertEquals((String)"Queue size", (long)this.messageCount, (long)count);
    }

    private String produceMessages() throws Exception {
        this.connection = this.createConnectionFactory().createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        String trackLastMessageId = "";
        MessageProducer producer = session.createProducer((Destination)this.destination);
        byte[] payload = new byte[1024];
        for (int i = 0; i < this.messageCount; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(payload);
            producer.send((Message)message);
            trackLastMessageId = message.getJMSMessageID();
        }
        producer.close();
        this.connection.close();
        return trackLastMessageId;
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (!this.mbeanServer.isRegistered(objectName)) {
            Assert.fail((String)("Could not find MBean!: " + String.valueOf(objectName)));
        }
        return objectName;
    }

    @Before
    public void setUp() throws Exception {
        this.createBroker();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        this.broker.stop();
    }

    protected BrokerService createBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        this.broker.setEnableStatistics(true);
        this.broker.addConnector("tcp://localhost:0");
        ((KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter()).setConcurrentStoreAndDispatchQueues(false);
        this.broker.deleteAllMessages();
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.setMemoryLimit(0x100000L);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(policyEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
        this.lastMessageId = this.produceMessages();
        return this.broker;
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }
}

