/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectiveMBeanRegistrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(SelectiveMBeanRegistrationTest.class);
    BrokerService brokerService;
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected boolean transacted;

    @Before
    public void createBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(true);
        ManagementContext managementContext = new ManagementContext();
        managementContext.setCreateConnector(false);
        managementContext.setSuppressMBean("endpoint=dynamicProducer,endpoint=Consumer,destinationName=ActiveMQ.Advisory.*");
        this.brokerService.setManagementContext(managementContext);
        this.brokerService.start();
        this.connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        this.mbeanServer = managementContext.getMBeanServer();
    }

    @Test
    public void testSuppression() throws Exception {
        this.connection = this.connectionFactory.createConnection("admin", "admin");
        this.connection.setClientID("MBeanTest");
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("AQueue");
        session.createConsumer((Destination)queue);
        Topic topic = session.createTopic("ATopic");
        session.createConsumer((Destination)topic);
        final ManagedRegionBroker managedRegionBroker = (ManagedRegionBroker)this.brokerService.getBroker().getAdaptor(ManagedRegionBroker.class);
        Assert.assertTrue((String)"one sub", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return managedRegionBroker.getQueueSubscribers().length == 1;
            }
        }));
        Assert.assertFalse((boolean)this.mbeanServer.isRegistered(managedRegionBroker.getQueueSubscribers()[0]));
        Assert.assertFalse((String)"not tracked as registered", (boolean)managedRegionBroker.getRegisteredMbeans().contains(managedRegionBroker.getQueueSubscribers()[0]));
        session.createProducer(null);
        Assert.assertTrue((String)"one sub", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return managedRegionBroker.getDynamicDestinationProducers().length == 1;
            }
        }));
        ObjectName query = new ObjectName(this.domain + ":type=Broker,brokerName=localhost,endpoint=dynamicProducer,*");
        Set<ObjectInstance> mbeans = this.mbeanServer.queryMBeans(query, null);
        Assert.assertEquals((long)0L, (long)mbeans.size());
        Assert.assertFalse((String)"producer not tracked as registered", (boolean)managedRegionBroker.getRegisteredMbeans().contains(managedRegionBroker.getDynamicDestinationProducers()[0]));
        query = new ObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationName=ActiveMQ.Advisory.*,*");
        mbeans = this.mbeanServer.queryMBeans(query, null);
        Assert.assertEquals((long)0L, (long)mbeans.size());
        ObjectName[] topicNames = managedRegionBroker.getTopics();
        Assert.assertTrue((String)"Some topics registered", (topicNames.length > 0 ? 1 : 0) != 0);
        for (ObjectName objectName : topicNames) {
            if (objectName.getKeyProperty("destinationName").contains("Advisory")) {
                Assert.assertFalse((String)("advisory topic not tracked as registered: " + String.valueOf(objectName)), (boolean)managedRegionBroker.getRegisteredMbeans().contains(objectName));
                continue;
            }
            Assert.assertTrue((String)("topic tracked as registered: " + String.valueOf(objectName)), (boolean)managedRegionBroker.getRegisteredMbeans().contains(objectName));
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }
}

