/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.lang.management.ManagementFactory;
import java.net.Socket;
import java.util.Set;
import javax.management.JMX;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.ConnectorViewMBean;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.JMXSupport;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportConnectorMBeanTest {
    private static final Logger LOG = LoggerFactory.getLogger(TransportConnectorMBeanTest.class);
    BrokerService broker;

    @Test
    public void verifyRemoteAddressInMbeanName() throws Exception {
        this.doVerifyRemoteAddressInMbeanName(true);
    }

    @Test
    public void verifyRemoteAddressNotInMbeanName() throws Exception {
        this.doVerifyRemoteAddressInMbeanName(false);
    }

    @Test
    public void verifyClientIdNetwork() throws Exception {
        this.doVerifyClientIdNetwork(false);
    }

    @Test
    public void verifyClientIdDuplexNetwork() throws Exception {
        this.doVerifyClientIdNetwork(true);
    }

    @Test
    public void testStartStop() throws Exception {
        this.createBroker(true);
        ConnectorViewMBean connectorViewMBean = JMX.newMBeanProxy(ManagementFactory.getPlatformMBeanServer(), BrokerMBeanSupport.createConnectorName((String)BrokerMBeanSupport.createBrokerObjectName((String)"org.apache.activemq", (String)"localhost").toString(), (String)"clientConnectors", (String)this.broker.getTransportConnectorByScheme("tcp").getPublishableConnectString()), ConnectorViewMBean.class);
        Assert.assertNotNull((Object)connectorViewMBean);
        TestCase.assertTrue((boolean)connectorViewMBean.isStarted());
        connectorViewMBean.stop();
        Assert.assertFalse((boolean)connectorViewMBean.isStarted());
        connectorViewMBean.start();
        TestCase.assertTrue((boolean)connectorViewMBean.isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVerifyClientIdNetwork(boolean duplex) throws Exception {
        this.createBroker(true);
        BrokerService networked = new BrokerService();
        networked.setBrokerName("networked");
        networked.setPersistent(false);
        NetworkConnector nc = networked.addNetworkConnector("static:" + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        nc.setDuplex(duplex);
        networked.start();
        try {
            TestCase.assertTrue((String)"presence of mbean with clientId", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    Set<ObjectName> registeredMbeans = TransportConnectorMBeanTest.this.getRegisteredMbeans();
                    return TransportConnectorMBeanTest.this.match("_outbound", registeredMbeans);
                }
            }));
        }
        finally {
            networked.stop();
        }
    }

    private void doVerifyRemoteAddressInMbeanName(boolean allowRemoteAddress) throws Exception {
        this.createBroker(allowRemoteAddress);
        ActiveMQConnection connection = this.createConnection();
        Set<ObjectName> registeredMbeans = this.getRegisteredMbeans();
        Assert.assertEquals((String)"presence of mbean with clientId", (Object)true, (Object)this.match(connection.getClientID(), registeredMbeans));
        Assert.assertEquals((String)"presence of mbean with local port", (Object)allowRemoteAddress, (Object)this.match(this.extractLocalPort(connection), registeredMbeans));
    }

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    private boolean match(String s, Set<ObjectName> registeredMbeans) {
        String encodedName = JMXSupport.encodeObjectNamePart((String)s);
        for (ObjectName name : registeredMbeans) {
            LOG.info("checking for match:" + encodedName + ", with: " + name.toString());
            if (!name.toString().contains(encodedName)) continue;
            return true;
        }
        return false;
    }

    private String extractLocalPort(ActiveMQConnection connection) throws Exception {
        Socket socket = (Socket)connection.getTransport().narrow(Socket.class);
        return String.valueOf(socket.getLocalPort());
    }

    private Set<ObjectName> getRegisteredMbeans() throws Exception {
        Thread.sleep(200L);
        return this.broker.getManagementContext().queryNames(null, null);
    }

    private ActiveMQConnection createConnection() throws Exception {
        String opts = "?jms.watchTopicAdvisories=false";
        ActiveMQConnection connection = (ActiveMQConnection)new ActiveMQConnectionFactory(String.valueOf(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri()) + "?jms.watchTopicAdvisories=false").createConnection();
        connection.start();
        return connection;
    }

    private void createBroker(boolean allowRemoteAddressInMbeanNames) throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.getManagementContext().setAllowRemoteAddressInMBeanNames(allowRemoteAddressInMbeanNames);
        this.broker.start();
    }
}

