/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;
import org.apache.activemq.xbean.XBeanBrokerFactory;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeQueueTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeQueueTest.class);
    protected int total = 10;
    protected Connection connection;
    public String messageSelector1;
    public String messageSelector2 = null;

    @Test
    public void testVirtualTopicCreation() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList1 = new ConsumerBean();
        ConsumerBean messageList2 = new ConsumerBean();
        messageList1.setVerbose(true);
        messageList2.setVerbose(true);
        Session session = this.connection.createSession(false, 1);
        Destination producerDestination = this.getProducerDestination();
        Destination destination1 = this.getConsumer1Dsetination();
        Destination destination2 = this.getConsumer2Dsetination();
        LOG.info("Sending to: " + String.valueOf(producerDestination));
        LOG.info("Consuming from: " + String.valueOf(destination1) + " and " + String.valueOf(destination2));
        MessageConsumer c1 = session.createConsumer(destination1, this.messageSelector1);
        MessageConsumer c2 = session.createConsumer(destination2, this.messageSelector2);
        c1.setMessageListener((MessageListener)messageList1);
        c2.setMessageListener((MessageListener)messageList2);
        MessageProducer producer = session.createProducer(producerDestination);
        CompositeQueueTest.assertNotNull((Object)producer);
        for (int i = 0; i < this.total; ++i) {
            producer.send((Message)this.createMessage(session, i));
        }
        this.assertMessagesArrived(messageList1, messageList2);
        this.assertOriginalDestination(messageList1, messageList2);
    }

    protected void assertMessagesArrived(ConsumerBean messageList1, ConsumerBean messageList2) {
        messageList1.assertMessagesArrived(this.total);
        messageList2.assertMessagesArrived(this.total);
    }

    protected void assertOriginalDestination(ConsumerBean messageList1, ConsumerBean messageList2) {
        ActiveMQMessage amqMessage;
        for (Message message : messageList1.getMessages()) {
            amqMessage = (ActiveMQMessage)message;
            CompositeQueueTest.assertEquals((Object)this.getProducerDestination(), (Object)amqMessage.getOriginalDestination());
        }
        for (Message message : messageList1.getMessages()) {
            amqMessage = (ActiveMQMessage)message;
            CompositeQueueTest.assertEquals((Object)this.getProducerDestination(), (Object)amqMessage.getOriginalDestination());
        }
    }

    protected TextMessage createMessage(Session session, int i) throws JMSException {
        TextMessage textMessage = session.createTextMessage("message: " + i);
        if (i % 2 != 0) {
            textMessage.setStringProperty("odd", "yes");
        } else {
            textMessage.setStringProperty("odd", "no");
        }
        textMessage.setIntProperty("i", i);
        return textMessage;
    }

    protected Destination getConsumer1Dsetination() {
        return new ActiveMQQueue("FOO");
    }

    protected Destination getConsumer2Dsetination() {
        return new ActiveMQTopic("BAR");
    }

    protected Destination getProducerDestination() {
        return new ActiveMQQueue("MY.QUEUE");
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        XBeanBrokerFactory factory = new XBeanBrokerFactory();
        BrokerService answer = factory.createBroker(new URI(this.getBrokerConfigUri()));
        return answer;
    }

    protected String getBrokerConfigUri() {
        return "org/apache/activemq/broker/virtual/composite-queue.xml";
    }
}

