/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Vector;
import junit.framework.Test;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;

public class VirtualTopicPubSubTest
extends EmbeddedBrokerTestSupport {
    private Vector<Connection> connections = new Vector();
    public int ackMode = 1;
    private boolean doneTwice = false;

    public static Test suite() {
        return VirtualTopicPubSubTest.suite(VirtualTopicPubSubTest.class);
    }

    public void initCombosForTestVirtualTopicCreation() {
        this.addCombinationValues("ackMode", new Object[]{1, 2});
    }

    public void testVirtualTopicCreation() throws Exception {
        this.doTestVirtualTopicCreation(10);
    }

    public void doTestVirtualTopicCreation(int total) throws Exception {
        ConsumerBean messageList = new ConsumerBean(){

            @Override
            public synchronized void onMessage(Message message) {
                super.onMessage(message);
                if (VirtualTopicPubSubTest.this.ackMode == 2) {
                    try {
                        message.acknowledge();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        messageList.setVerbose(true);
        String queueAName = this.getVirtualTopicConsumerName();
        ActiveMQQueue queue1 = new ActiveMQQueue(queueAName);
        ActiveMQQueue queue2 = new ActiveMQQueue(queueAName);
        Session session = this.createStartAndTrackConnection().createSession(false, this.ackMode);
        MessageConsumer c1 = session.createConsumer((Destination)queue1);
        session = this.createStartAndTrackConnection().createSession(false, this.ackMode);
        MessageConsumer c2 = session.createConsumer((Destination)queue2);
        c1.setMessageListener((MessageListener)messageList);
        c2.setMessageListener((MessageListener)messageList);
        Session producerSession = this.createStartAndTrackConnection().createSession(false, this.ackMode);
        MessageProducer producer = producerSession.createProducer((Destination)new ActiveMQTopic(this.getVirtualTopicName()));
        VirtualTopicPubSubTest.assertNotNull((Object)producer);
        for (int i = 0; i < total; ++i) {
            producer.send((Message)producerSession.createTextMessage("message: " + i));
        }
        messageList.assertMessagesArrived(total);
        if (!this.doneTwice) {
            this.doneTwice = true;
            this.doTestVirtualTopicCreation(0);
        }
    }

    private Connection createStartAndTrackConnection() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        this.connections.add(connection);
        return connection;
    }

    protected String getVirtualTopicName() {
        return "VirtualTopic.TEST";
    }

    protected String getVirtualTopicConsumerName() {
        return "Consumer.A.VirtualTopic.TEST";
    }

    @Override
    protected void tearDown() throws Exception {
        for (Connection connection : this.connections) {
            connection.close();
        }
        super.tearDown();
    }
}

