/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;

public class AMQ2571Test
extends EmbeddedBrokerTestSupport {
    public void testTempQueueClosing() {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.bindAddress);
            connectionFactory.setAlwaysSyncSend(true);
            Connection connectionA = connectionFactory.createConnection();
            connectionA.start();
            Session sessionA = connectionA.createSession(false, 1);
            TemporaryQueue tempQueue = sessionA.createTemporaryQueue();
            Connection connectionB = connectionFactory.createConnection();
            connectionB.start();
            Session sessionB = connectionB.createSession(false, 1);
            final MessageProducer producerB = sessionB.createProducer((Destination)tempQueue);
            producerB.setDeliveryMode(1);
            final TextMessage message = sessionB.createTextMessage("Testing AMQ TempQueue.");
            Thread sendingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        long end = System.currentTimeMillis() + 300000L;
                        while (System.currentTimeMillis() < end) {
                            producerB.send((Message)message);
                        }
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            });
            sendingThread.start();
            connectionA.close();
            sendingThread.join(300000L);
            try {
                producerB.send((Message)message);
                AMQ2571Test.fail((String)"Involuntary recreated temporary queue.");
            }
            catch (JMSException e) {
                AMQ2571Test.assertTrue((String)"TempQueue does not exist anymore.", (boolean)true);
            }
        }
        catch (Exception e) {
            AMQ2571Test.fail((String)("Unexpected exception " + String.valueOf(e)));
        }
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "vm://localhost";
        this.setAutoFail(true);
        super.setUp();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        answer.setUseJmx(false);
        return answer;
    }
}

