/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import java.io.File;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.FilePendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class AMQ2616Test {
    @Rule
    public TestName test = new TestName();
    private static final int NUMBER = 2000;
    private BrokerService brokerService;
    private final String ACTIVEMQ_BROKER_BIND = "tcp://0.0.0.0:0";
    private String connectionUri;

    @Test(timeout=90000L)
    public void testQueueResourcesReleased() throws Exception {
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(this.connectionUri);
        Connection tempConnection = fac.createConnection();
        tempConnection.start();
        Session tempSession = tempConnection.createSession(false, 1);
        TemporaryQueue tempQueue = tempSession.createTemporaryQueue();
        Connection testConnection = fac.createConnection();
        final long startUsage = this.brokerService.getSystemUsage().getMemoryUsage().getUsage();
        Session testSession = testConnection.createSession(false, 1);
        MessageProducer testProducer = testSession.createProducer((Destination)tempQueue);
        byte[] payload = new byte[4096];
        for (int i = 0; i < 2000; ++i) {
            BytesMessage msg = testSession.createBytesMessage();
            msg.writeBytes(payload);
            testProducer.send((Message)msg);
        }
        long endUsage = this.brokerService.getSystemUsage().getMemoryUsage().getUsage();
        Assert.assertFalse((startUsage == endUsage ? 1 : 0) != 0);
        tempConnection.close();
        Assert.assertTrue((String)"Usage should return to original", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return AMQ2616Test.this.brokerService.getSystemUsage().getMemoryUsage().getUsage() == startUsage;
            }
        }));
    }

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        KahaDBPersistenceAdapter adaptor = new KahaDBPersistenceAdapter();
        adaptor.setJournalDiskSyncStrategy(Journal.JournalDiskSyncStrategy.NEVER.name());
        File file = new File("target/AMQ2616Test");
        IOHelper.mkdirs((File)file);
        IOHelper.deleteChildren((File)file);
        adaptor.setDirectory(file);
        this.brokerService.setPersistenceAdapter((PersistenceAdapter)adaptor);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry pe = new PolicyEntry();
        pe.setMemoryLimit(0xA00000L);
        pe.setOptimizedDispatch(true);
        pe.setProducerFlowControl(false);
        pe.setExpireMessagesPeriod(1000L);
        pe.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new FilePendingQueueMessageStoragePolicy());
        policyMap.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)pe);
        this.brokerService.setDestinationPolicy(policyMap);
        this.brokerService.getSystemUsage().getMemoryUsage().setLimit(0x1400000L);
        this.brokerService.getSystemUsage().getTempUsage().setLimit(0xC800000L);
        this.brokerService.addConnector("tcp://0.0.0.0:0");
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.brokerService.getTransportConnectors().get(0)).getPublishableConnectString();
        new ActiveMQQueue(this.test.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService = null;
    }
}

