/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.util.DefaultIOExceptionHandler;
import org.apache.activemq.util.IOExceptionHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AMQ2736Test {
    BrokerService broker;

    @Test
    public void testRollbackOnRecover() throws Exception {
        this.broker = this.createAndStartBroker(true);
        DefaultIOExceptionHandler ignoreAllExceptionsIOExHandler = new DefaultIOExceptionHandler();
        ignoreAllExceptionsIOExHandler.setIgnoreAllErrors(true);
        this.broker.setIoExceptionHandler((IOExceptionHandler)ignoreAllExceptionsIOExHandler);
        ActiveMQConnectionFactory f = new ActiveMQConnectionFactory("vm://localhost?async=false");
        f.setAlwaysSyncSend(true);
        Connection c = f.createConnection();
        c.start();
        Session s = c.createSession(true, 0);
        MessageProducer p = s.createProducer((Destination)new ActiveMQQueue("Tx"));
        p.send((Message)s.createTextMessage("aa"));
        KahaDBPersistenceAdapter pa = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        KahaDBStore store = pa.getStore();
        Assert.assertNotNull((Object)("last tx location is present " + String.valueOf(store.getInProgressTxLocationRange()[1])));
        store.getJournal().close();
        try {
            store.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createAndStartBroker(false);
        pa = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        store = pa.getStore();
        Assert.assertNull((String)"in progress tx location is present ", (Object)store.getInProgressTxLocationRange()[0]);
    }

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    private BrokerService createAndStartBroker(boolean deleteAll) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(deleteAll);
        broker.setUseJmx(false);
        broker.getManagementContext().setCreateConnector(false);
        broker.start();
        return broker;
    }
}

