/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.bugs.AMQ3992Test;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4083Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ3992Test.class);
    private static BrokerService brokerService;
    private static String BROKER_ADDRESS;
    private static String TEST_QUEUE;
    private static ActiveMQQueue queue;
    private final int messageCount = 100;
    private String connectionUri;
    private String[] data;

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        brokerService.setDeleteAllMessagesOnStartup(true);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        brokerService.start();
        brokerService.waitUntilStarted();
        this.data = new String[100];
        for (int i = 0; i < 100; ++i) {
            this.data[i] = "Text for message: " + i + " at " + String.valueOf(new Date());
        }
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test
    public void testExpiredMsgsBeforeNonExpired() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.getPrefetchPolicy().setQueuePrefetch(400);
        Session session = connection.createSession(false, 2);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)session.createTextMessage(), 2, 4, 4000L);
        }
        producer.send((Message)session.createTextMessage());
        TimeUnit.SECONDS.sleep(5L);
        final QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)101L, (long)queueView.getInFlightCount());
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    message.acknowledge();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        });
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertEquals((long)0L, (long)queueView.getInFlightCount());
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)session.createTextMessage());
        }
        Assert.assertTrue((String)("Inflight count should reach zero, currently: " + queueView.getInFlightCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getInFlightCount() == 0L;
            }
        }));
        LOG.info("Dequeued Count: {}", (Object)queueView.getDequeueCount());
        LOG.info("Dispatch Count: {}", (Object)queueView.getDispatchCount());
        LOG.info("Enqueue Count: {}", (Object)queueView.getEnqueueCount());
        LOG.info("Expired Count: {}", (Object)queueView.getExpiredCount());
        LOG.info("InFlight Count: {}", (Object)queueView.getInFlightCount());
    }

    @Test
    public void testExpiredMsgsBeforeNonExpiredWithTX() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.getPrefetchPolicy().setQueuePrefetch(400);
        final Session session = connection.createSession(true, 0);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)session.createTextMessage(), 2, 4, 4000L);
        }
        producer.send((Message)session.createTextMessage());
        session.commit();
        TimeUnit.SECONDS.sleep(5L);
        final QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)101L, (long)queueView.getInFlightCount());
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    session.commit();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        });
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertEquals((long)0L, (long)queueView.getInFlightCount());
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)session.createTextMessage());
        }
        session.commit();
        Assert.assertTrue((String)("Inflight count should reach zero, currently: " + queueView.getInFlightCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getInFlightCount() == 0L;
            }
        }));
        LOG.info("Dequeued Count: {}", (Object)queueView.getDequeueCount());
        LOG.info("Dispatch Count: {}", (Object)queueView.getDispatchCount());
        LOG.info("Enqueue Count: {}", (Object)queueView.getEnqueueCount());
        LOG.info("Expired Count: {}", (Object)queueView.getExpiredCount());
        LOG.info("InFlight Count: {}", (Object)queueView.getInFlightCount());
    }

    @Test
    public void testExpiredMsgsInterleavedWithNonExpired() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.getPrefetchPolicy().setQueuePrefetch(400);
        Session session = connection.createSession(false, 2);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < 200; ++i) {
            if (i % 2 == 0) {
                producer.send((Message)session.createTextMessage(), 2, 4, 4000L);
                continue;
            }
            producer.send((Message)session.createTextMessage());
        }
        TimeUnit.SECONDS.sleep(5L);
        final QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)200L, (long)queueView.getInFlightCount());
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    LOG.debug("Acking message: {}", (Object)message);
                    message.acknowledge();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        });
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertTrue((String)("Inflight count should reach zero, currently: " + queueView.getInFlightCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getInFlightCount() == 0L;
            }
        }));
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)session.createTextMessage());
        }
        Assert.assertTrue((String)("Inflight count should reach zero, currently: " + queueView.getInFlightCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getInFlightCount() == 0L;
            }
        }));
        LOG.info("Dequeued Count: {}", (Object)queueView.getDequeueCount());
        LOG.info("Dispatch Count: {}", (Object)queueView.getDispatchCount());
        LOG.info("Enqueue Count: {}", (Object)queueView.getEnqueueCount());
        LOG.info("Expired Count: {}", (Object)queueView.getExpiredCount());
        LOG.info("InFlight Count: {}", (Object)queueView.getInFlightCount());
    }

    @Test
    public void testExpiredMsgsInterleavedWithNonExpiredCumulativeAck() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.getPrefetchPolicy().setQueuePrefetch(400);
        Session session = connection.createSession(false, 2);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < 200; ++i) {
            if (i % 2 == 0) {
                producer.send((Message)session.createTextMessage(), 2, 4, 4000L);
                continue;
            }
            producer.send((Message)session.createTextMessage());
        }
        TimeUnit.SECONDS.sleep(5L);
        final QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)200L, (long)queueView.getInFlightCount());
        final AtomicInteger msgCount = new AtomicInteger();
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    if (msgCount.incrementAndGet() == 100) {
                        LOG.debug("Acking message: {}", (Object)message);
                        message.acknowledge();
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        });
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertTrue((String)("Inflight count should reach zero, currently: " + queueView.getInFlightCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getInFlightCount() == 0L;
            }
        }));
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    LOG.debug("Acking message: {}", (Object)message);
                    message.acknowledge();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        });
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)session.createTextMessage());
        }
        Assert.assertTrue((String)("Inflight count should reach zero, currently: " + queueView.getInFlightCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getInFlightCount() == 0L;
            }
        }));
        LOG.info("Dequeued Count: {}", (Object)queueView.getDequeueCount());
        LOG.info("Dispatch Count: {}", (Object)queueView.getDispatchCount());
        LOG.info("Enqueue Count: {}", (Object)queueView.getEnqueueCount());
        LOG.info("Expired Count: {}", (Object)queueView.getExpiredCount());
        LOG.info("InFlight Count: {}", (Object)queueView.getInFlightCount());
    }

    @Test
    public void testExpiredBatchBetweenNonExpiredMessages() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.getPrefetchPolicy().setQueuePrefetch(400);
        Session session = connection.createSession(false, 2);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        producer.send((Message)session.createTextMessage());
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)session.createTextMessage(), 2, 4, 4000L);
        }
        producer.send((Message)session.createTextMessage());
        TimeUnit.SECONDS.sleep(5L);
        final QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)102L, (long)queueView.getInFlightCount());
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    message.acknowledge();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        });
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertTrue((String)("Inflight count should reach zero, currently: " + queueView.getInFlightCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getInFlightCount() == 0L;
            }
        }));
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)session.createTextMessage());
        }
        Assert.assertTrue((String)("Inflight count should reach zero, currently: " + queueView.getInFlightCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getInFlightCount() == 0L;
            }
        }));
        LOG.info("Dequeued Count: {}", (Object)queueView.getDequeueCount());
        LOG.info("Dispatch Count: {}", (Object)queueView.getDispatchCount());
        LOG.info("Enqueue Count: {}", (Object)queueView.getEnqueueCount());
        LOG.info("Expired Count: {}", (Object)queueView.getExpiredCount());
        LOG.info("InFlight Count: {}", (Object)queueView.getInFlightCount());
    }

    @Test
    public void testConsumeExpiredQueueAndDlq() throws Exception {
        Message received;
        TextMessage message;
        int i;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producerNormal = session.createProducer((Destination)queue);
        MessageProducer producerExpire = session.createProducer((Destination)queue);
        producerExpire.setTimeToLive(500L);
        MessageConsumer dlqConsumer = session.createConsumer((Destination)session.createQueue("ActiveMQ.DLQ"));
        connection.start();
        Connection consumerConnection = factory.createConnection();
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setAll(10);
        ((ActiveMQConnection)consumerConnection).setPrefetchPolicy(prefetchPolicy);
        Session consumerSession = consumerConnection.createSession(false, 2);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)queue);
        consumerConnection.start();
        String msgBody = new String(new byte[20480]);
        for (i = 0; i < this.data.length; ++i) {
            message = session.createTextMessage(msgBody);
            producerExpire.send((Destination)queue, (Message)message);
        }
        for (i = 0; i < this.data.length; ++i) {
            message = session.createTextMessage(msgBody);
            producerNormal.send((Destination)queue, (Message)message);
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        while ((received = consumer.receive(1000L)) != null) {
            messages.add(received);
            if (messages.size() == 1) {
                TimeUnit.SECONDS.sleep(1L);
            }
            received.acknowledge();
        }
        Assert.assertEquals((String)"got messages", (long)101L, (long)messages.size());
        ArrayList<Message> dlqMessages = new ArrayList<Message>();
        while ((received = dlqConsumer.receive(1000L)) != null) {
            dlqMessages.add(received);
        }
        Assert.assertEquals((String)"got dlq messages", (long)(this.data.length - 1), (long)dlqMessages.size());
        QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        LOG.info("Dequeued Count: {}", (Object)queueView.getDequeueCount());
        LOG.info("Dispatch Count: {}", (Object)queueView.getDispatchCount());
        LOG.info("Enqueue Count: {}", (Object)queueView.getEnqueueCount());
        LOG.info("Expired Count: {}", (Object)queueView.getExpiredCount());
        LOG.info("InFlight Count: {}", (Object)queueView.getInFlightCount());
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws Exception {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queue.getQueueName());
        QueueViewMBean proxy = (QueueViewMBean)brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    static {
        BROKER_ADDRESS = "tcp://localhost:0";
        TEST_QUEUE = "testQueue";
        queue = new ActiveMQQueue(TEST_QUEUE);
    }
}

