/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.util.TimeStampingBrokerPlugin;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ4475Test {
    private final Log LOG = LogFactory.getLog(AMQ4475Test.class);
    private final int NUM_MSGS = 1000;
    private final int MAX_THREADS = 20;
    private BrokerService broker;
    private String connectionUri;
    private final ExecutorService executor = Executors.newFixedThreadPool(20);
    private final ActiveMQQueue original = new ActiveMQQueue("jms/AQueue");
    private final ActiveMQQueue rerouted = new ActiveMQQueue("jms/AQueue_proxy");

    @Before
    public void setUp() throws Exception {
        TimeStampingBrokerPlugin tsbp = new TimeStampingBrokerPlugin();
        tsbp.setZeroExpirationOverride(432000000L);
        tsbp.setTtlCeiling(432000000L);
        tsbp.setFutureOnly(true);
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(true);
        this.broker.setPlugins(new BrokerPlugin[]{tsbp});
        this.connectionUri = this.broker.addConnector("tcp://localhost:0").getPublishableConnectString();
        IndividualDeadLetterStrategy strategy = new IndividualDeadLetterStrategy();
        strategy.setProcessExpired(true);
        strategy.setUseQueueForQueueMessages(true);
        strategy.setQueuePrefix("DLQ.");
        strategy.setProcessNonPersistent(true);
        PolicyEntry policy = new PolicyEntry();
        policy.setTimeBeforeDispatchStarts(3000);
        policy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.broker.setDestinationPolicy(pMap);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void testIndividualDeadLetterAndTimeStampPlugin() {
        this.LOG.info((Object)"Starting test ..");
        long startTime = System.nanoTime();
        ArrayList<Future<ProducerTask>> tasks = new ArrayList<Future<ProducerTask>>();
        for (int index = 0; index < 1; ++index) {
            ProducerTask p = new ProducerTask(this.connectionUri, this.original, 1000);
            Future<ProducerTask> future = this.executor.submit(p, p);
            tasks.add(future);
        }
        ForwardingConsumerThread f1 = new ForwardingConsumerThread(this.original, this.rerouted, 1000);
        f1.start();
        ConsumerThread c1 = new ConsumerThread(this.connectionUri, this.rerouted, 1000);
        c1.start();
        this.LOG.info((Object)"Waiting on consumers and producers to exit");
        try {
            for (Future future : tasks) {
                ProducerTask e = (ProducerTask)future.get();
                this.LOG.info((Object)("[Completed] " + e.dest.getPhysicalName()));
            }
            this.executor.shutdown();
            this.LOG.info((Object)"Producing threads complete, waiting on ACKs");
            f1.join(TimeUnit.MINUTES.toMillis(2L));
            c1.join(TimeUnit.MINUTES.toMillis(2L));
        }
        catch (ExecutionException e) {
            this.LOG.warn((Object)"Caught unexpected exception: {}", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException ie) {
            this.LOG.warn((Object)"Caught unexpected exception: {}", (Throwable)ie);
            throw new RuntimeException(ie);
        }
        Assert.assertFalse((boolean)f1.isFailed());
        Assert.assertFalse((boolean)c1.isFailed());
        long estimatedTime = System.nanoTime() - startTime;
        this.LOG.info((Object)("Testcase duration (seconds): " + (double)estimatedTime / 1.0E9));
        this.LOG.info((Object)"Consumers and producers exited, all msgs received as expected");
    }

    public class ProducerTask
    implements Runnable {
        private final String uri;
        private final ActiveMQQueue dest;
        private final int count;

        public ProducerTask(String uri, ActiveMQQueue dest, int count) {
            this.uri = uri;
            this.dest = dest;
            this.count = count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            try {
                String destName = "";
                try {
                    destName = this.dest.getQueueName();
                }
                catch (JMSException e) {
                    AMQ4475Test.this.LOG.warn((Object)"Caught unexpected exception: {}", (Throwable)e);
                }
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.uri);
                connection = connectionFactory.createConnection();
                Session session = connection.createSession(false, 1);
                MessageProducer producer = session.createProducer((Destination)this.dest);
                connection.start();
                producer.setDeliveryMode(2);
                String msg = "Test Message";
                for (int i = 0; i < this.count; ++i) {
                    producer.send((Message)session.createTextMessage(msg + this.dest.getQueueName() + " " + i));
                }
                AMQ4475Test.this.LOG.info((Object)("[" + destName + "] Sent " + this.count + " msgs"));
            }
            catch (Exception e) {
                AMQ4475Test.this.LOG.warn((Object)"Caught unexpected exception: {}", (Throwable)e);
            }
            finally {
                try {
                    connection.close();
                }
                catch (Throwable e) {
                    AMQ4475Test.this.LOG.warn((Object)"Caught unexpected exception: {}", e);
                }
            }
        }
    }

    public class ForwardingConsumerThread
    extends Thread {
        private final ActiveMQQueue original;
        private final ActiveMQQueue forward;
        private int blockSize = 0;
        private final int PARALLEL = 1;
        private boolean failed;

        public ForwardingConsumerThread(ActiveMQQueue original, ActiveMQQueue forward, int total) {
            this.original = original;
            this.forward = forward;
            this.blockSize = total / 1;
        }

        public boolean isFailed() {
            return this.failed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            try {
                for (int index = 0; index < 1; ++index) {
                    Message msg1;
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                    connection = factory.createConnection();
                    Session session = connection.createSession(false, 1);
                    MessageConsumer consumer = session.createConsumer((Destination)this.original);
                    MessageProducer producer = session.createProducer((Destination)this.forward);
                    connection.start();
                    int count = 0;
                    while (count < this.blockSize && (msg1 = consumer.receive(10000L)) != null) {
                        if (msg1 instanceof ActiveMQTextMessage) {
                            if (count % 100 == 0) {
                                AMQ4475Test.this.LOG.info((Object)("Consuming -> " + String.valueOf(((ActiveMQTextMessage)msg1).getDestination()) + " count=" + count));
                            }
                            producer.send(msg1);
                            ++count;
                            continue;
                        }
                        AMQ4475Test.this.LOG.info((Object)("Skipping unknown msg type " + String.valueOf(msg1)));
                    }
                    AMQ4475Test.this.LOG.info((Object)("[" + this.original.getQueueName() + "] completed segment (" + index + " of " + this.blockSize + ")"));
                    connection.close();
                }
            }
            catch (Exception e) {
                AMQ4475Test.this.LOG.warn((Object)"Caught unexpected exception: {}", (Throwable)e);
            }
            finally {
                AMQ4475Test.this.LOG.debug((Object)(this.getName() + ": is stopping"));
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public class ConsumerThread
    extends Thread {
        private final String uri;
        private final ActiveMQQueue dest;
        private int blockSize = 0;
        private final int PARALLEL = 1;
        private boolean failed;

        public ConsumerThread(String uri, ActiveMQQueue dest, int total) {
            this.uri = uri;
            this.dest = dest;
            this.blockSize = total / 1;
        }

        public boolean isFailed() {
            return this.failed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            try {
                for (int index = 0; index < 1; ++index) {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.uri);
                    connection = factory.createConnection();
                    Session session = connection.createSession(false, 1);
                    MessageConsumer consumer = session.createConsumer((Destination)this.dest);
                    connection.start();
                    int count = 0;
                    while (count < this.blockSize) {
                        Message msg1 = consumer.receive(10000L);
                        if (msg1 != null) {
                            if (msg1 instanceof ActiveMQTextMessage) {
                                if (count % 100 == 0) {
                                    AMQ4475Test.this.LOG.info((Object)("Consuming -> " + String.valueOf(((ActiveMQTextMessage)msg1).getDestination()) + " count=" + count));
                                }
                                ++count;
                                continue;
                            }
                            AMQ4475Test.this.LOG.info((Object)("Skipping unknown msg type " + String.valueOf(msg1)));
                            continue;
                        }
                        this.failed = true;
                        break;
                    }
                    AMQ4475Test.this.LOG.info((Object)("[" + this.dest.getQueueName() + "] completed segment (" + index + " of " + this.blockSize + ")"));
                    connection.close();
                }
            }
            catch (Exception e) {
                AMQ4475Test.this.LOG.warn((Object)"Caught unexpected exception: {}", (Throwable)e);
            }
            finally {
                AMQ4475Test.this.LOG.debug((Object)(this.getName() + ": is stopping"));
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

