/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import java.io.IOException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.ConsumerThread;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4582Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ4582Test.class);
    BrokerService broker;
    Connection connection;
    Session session;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    public static final int PRODUCER_COUNT = 10;
    public static final int CONSUMER_COUNT = 10;
    public static final int MESSAGE_COUNT = 1000;
    final ConsumerThread[] consumers = new ConsumerThread[10];
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            try {
                this.broker.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void simpleTest() throws Exception {
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("enabledCipherSuites=BADSUITE");
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        try {
            this.broker.addConnector("ssl://localhost:0?transport.needClientAuth=true&transport.enabledCipherSuites=BADSUITE");
            this.broker.start();
            this.broker.waitUntilStarted();
        }
        catch (Exception e) {
            LOG.info("BrokerService threw:", (Throwable)e);
            throw e;
        }
    }
}

