/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.TextMessage;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AMQ4899Listener
implements MessageListener {
    Logger LOG = LoggerFactory.getLogger(AMQ4899Listener.class);
    CountDownLatch toConsume;
    String id;

    public AMQ4899Listener(String id, CountDownLatch started, CountDownLatch toConsume) {
        this.id = id;
        this.toConsume = toConsume;
        started.countDown();
    }

    public void onMessage(Message message) {
        this.toConsume.countDown();
        try {
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                this.LOG.debug("Listener {} received [{}]", (Object)this.id, (Object)textMessage.getText());
            } else {
                this.LOG.error("Listener {} Expected a TextMessage, got {}", (Object)this.id, (Object)message.getClass().getCanonicalName());
            }
        }
        catch (JMSException e) {
            this.LOG.error("Unexpected JMSException in Listener " + this.id, (Throwable)e);
        }
    }
}

