/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.Arrays;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AMQ5863CompositePublishTest {
    static Logger LOG = LoggerFactory.getLogger(AMQ5863CompositePublishTest.class);
    String brokerUrl;
    BrokerService brokerService;
    @Parameterized.Parameter(value=0)
    public TestSupport.PersistenceAdapterChoice persistenceAdapterChoice = TestSupport.PersistenceAdapterChoice.KahaDB;

    @Parameterized.Parameters(name="#store:{0}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({TestSupport.PersistenceAdapterChoice.KahaDB}, {TestSupport.PersistenceAdapterChoice.JDBC});
    }

    @Before
    public void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        TestSupport.setPersistenceAdapter(this.brokerService, this.persistenceAdapterChoice);
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.brokerService.setUseJmx(false);
        this.brokerService.setAdvisorySupport(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setUseCache(false);
        defaultEntry.setExpireMessagesPeriod(0L);
        policyMap.setDefaultEntry(defaultEntry);
        this.brokerService.setDestinationPolicy(policyMap);
        TransportConnector transportConnector = this.brokerService.addConnector("tcp://0.0.0.0:0");
        this.brokerService.start();
        this.brokerUrl = transportConnector.getPublishableConnectString();
    }

    @After
    public void stopBroker() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        ActiveMQQueue compositeSendTo = new ActiveMQQueue("one,two,three");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.brokerUrl);
        connectionFactory.setWatchTopicAdvisories(false);
        connection.start();
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(false, 1);
            session.createProducer((Destination)compositeSendTo).send((Message)session.createTextMessage("Bing"));
            for (ActiveMQDestination dest : compositeSendTo.getCompositeDestinations()) {
                Message message = session.createConsumer((Destination)dest).receive(5000L);
                LOG.info("From: " + String.valueOf(dest) + ", " + String.valueOf(message.getJMSDestination()));
                Assert.assertNotNull((String)("got message from: " + String.valueOf(dest)), (Object)message);
            }
        }
    }
}

