/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6000Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ6000Test.class);
    private ActiveMQConnection connection;
    private BrokerService broker;
    private String connectionUri;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        this.broker.setPersistent(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setExpireMessagesPeriod(0L);
        defaultEntry.setUseCache(false);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.connection = this.createConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=30000L)
    public void testResumeNotDispatching() throws Exception {
        this.sendMessage();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.getMethodName());
        QueueViewMBean queueView = this.getProxyToQueue(this.name.getMethodName());
        LOG.info("Pausing Queue");
        queueView.pause();
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Assert.assertNull((Object)consumer.receive(100L));
        LOG.info("Resuming Queue");
        queueView.resume();
        Assert.assertNotNull((Object)consumer.receive(2000L));
    }

    protected QueueViewMBean getProxyToQueue(String name) throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + name);
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    protected ActiveMQConnection createConnection() throws Exception {
        return (ActiveMQConnection)this.createConnectionFactory().createConnection();
    }

    private void sendMessage() throws Exception {
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.getMethodName());
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send(session.createMessage());
        session.close();
    }
}

