/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ7270Test
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ7270Test.class);
    final int messageCount = 150;
    final int messageSize = 0x100000;
    final int maxPageSize = 50;
    final ActiveMQQueue activeMQQueue = new ActiveMQQueue("BIG");
    BrokerService broker;
    ActiveMQConnectionFactory factory;

    protected void configureBroker() throws Exception {
        this.broker.setPersistent(false);
        this.broker.setAdvisorySupport(false);
        PolicyMap pMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setExpireMessagesPeriod(0L);
        policy.setMaxPageSize(50);
        pMap.setDefaultEntry(policy);
        this.broker.setDestinationPolicy(pMap);
    }

    public void testConcurrentCopyMatchingPageSizeOk() throws Exception {
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.activeMQQueue);
        producer.setDeliveryMode(1);
        BytesMessage bytesMessage = session.createBytesMessage();
        for (int i = 0; i < 150; ++i) {
            bytesMessage.setIntProperty("id", i);
            producer.send((Destination)this.activeMQQueue, (Message)bytesMessage);
        }
        final QueueViewMBean queueViewMBean = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(this.broker.getAdminView().getQueues()[0], QueueViewMBean.class, false);
        LOG.info(queueViewMBean.getName() + " Size: " + queueViewMBean.getEnqueueCount());
        connection.close();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 20; ++i) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        queueViewMBean.copyMatchingMessagesTo("id=149", "To");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        executor.shutdown();
        AMQ7270Test.assertTrue((String)"all work done", (boolean)executor.awaitTermination(30L, TimeUnit.SECONDS));
        Queue underTest = (Queue)((RegionBroker)this.broker.getRegionBroker()).getQueueRegion().getDestinationMap().get(this.activeMQQueue);
        AMQ7270Test.assertEquals((String)("page Size as expected " + String.valueOf(underTest)), (int)50, (int)underTest.getMaxPageSize());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.setBrokerName("thisOne");
        this.configureBroker();
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory("vm://thisOne?jms.alwaysSyncSend=true");
        this.factory.setWatchTopicAdvisories(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }
}

