/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.TimeoutException;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Assert;

public class DoubleExpireTest
extends EmbeddedBrokerTestSupport {
    private static final long MESSAGE_TTL_MILLIS = 1000L;
    private static final long MAX_TEST_TIME_MILLIS = 60000L;

    @Override
    public void setUp() throws Exception {
        this.setAutoFail(true);
        this.setMaxTestTime(60000L);
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleExpireWithoutMove() throws Exception {
        ActiveMQDestination DLQ = this.createDestination("ActiveMQ.DLQ");
        try (Connection conn = this.createConnection();){
            conn.start();
            Session session = conn.createSession(false, 1);
            Assert.assertEquals((long)0L, (long)this.getSize(this.destination));
            Assert.assertEquals((long)0L, (long)this.getSize(DLQ));
            MessageProducer producer = session.createProducer((Destination)this.destination);
            TextMessage testMessage = session.createTextMessage("test message");
            producer.send((Message)testMessage, 2, 4, 1000L);
            Assert.assertEquals((long)1L, (long)this.getSize(this.destination));
            this.waitForSize(this.destination, 0, 60000L);
            Assert.assertEquals((long)1L, (long)this.getSize(DLQ));
            MessageConsumer consumer = session.createConsumer((Destination)DLQ);
            Message expiredMessage = consumer.receive();
            Assert.assertEquals((Object)testMessage.getJMSMessageID(), (Object)expiredMessage.getJMSMessageID());
            producer.send(expiredMessage, 2, 4, 1000L);
            Assert.assertEquals((long)1L, (long)this.getSize(this.destination));
            Assert.assertEquals((long)0L, (long)this.getSize(DLQ));
            Assert.assertNotSame((Object)testMessage.getJMSMessageID(), (Object)expiredMessage.getJMSMessageID());
            this.waitForSize(this.destination, 0, 60000L);
            Assert.assertEquals((long)1L, (long)this.getSize(DLQ));
            Message reexpiredMessage = consumer.receive();
            Assert.assertEquals((Object)expiredMessage.getJMSMessageID(), (Object)reexpiredMessage.getJMSMessageID());
        }
    }

    private Queue getPhysicalDestination(ActiveMQDestination destination) throws Exception {
        return (Queue)this.broker.getAdminView().getBroker().getDestinationMap().get(destination);
    }

    private long getSize(ActiveMQDestination destination) throws Exception {
        return this.getPhysicalDestination(destination) != null ? this.getPhysicalDestination(destination).getDestinationStatistics().getMessages().getCount() : 0L;
    }

    private void waitForSize(ActiveMQDestination destination, int size, long timeoutMillis) throws Exception, TimeoutException {
        long startTimeMillis = System.currentTimeMillis();
        while (this.getSize(destination) != (long)size && System.currentTimeMillis() < startTimeMillis + timeoutMillis) {
            Thread.sleep(250L);
        }
        if (this.getSize(destination) != (long)size) {
            throw new TimeoutException("Destination " + destination.getPhysicalName() + " did not reach size " + size + " within " + timeoutMillis + "ms.");
        }
    }
}

