/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiKahaDBMultipleFilteredAdapterTest {
    private static final int maxFileLength = 0x2000000;
    private static final String QUEUE_NAME = "QUEUE.amqMultiKahadbMultiFilteredAdapter";
    private static final String TOPIC_NAME = "TOPIC.amqMultiKahadbMultiFilteredAdapter";
    private static final int MESSAGE_COUNT = 100;
    private BrokerService broker;
    private ActiveMQConnectionFactory cf;

    @Before
    public void setUp() throws Exception {
        this.prepareBrokerWithMultiStore(true);
        TransportConnector connector = this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.cf = new ActiveMQConnectionFactory("failover://(" + String.valueOf(connector.getConnectUri()) + ")");
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    @Test
    public void testTopicWildcardAndPerDestinationFilteredAdapter() throws Exception {
        this.sendMessages(false);
        this.sendMessages(true);
        MultiKahaDBPersistenceAdapter multiKaha = (MultiKahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        Assert.assertEquals((long)2L, (long)multiKaha.getAdapters().size());
        Set dirs = multiKaha.getAdapters().stream().map(adapter -> adapter.getDirectory()).collect(Collectors.toSet());
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.prepareBrokerWithMultiStore(false);
        this.broker.start();
        this.broker.waitUntilStarted();
        multiKaha = (MultiKahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        Assert.assertEquals((long)2L, (long)multiKaha.getAdapters().size());
        Assert.assertEquals(dirs, multiKaha.getAdapters().stream().map(adapter -> adapter.getDirectory()).collect(Collectors.toSet()));
    }

    private void sendMessages(boolean isTopic) throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession();
        MessageProducer producer = isTopic ? session.createProducer((Destination)session.createTopic(TOPIC_NAME)) : session.createProducer((Destination)session.createQueue(QUEUE_NAME));
        producer.setDeliveryMode(2);
        for (int i = 0; i < 100; ++i) {
            TextMessage message = session.createTextMessage("Test message " + i);
            producer.send((Message)message);
        }
        producer.close();
        session.close();
        connection.close();
        if (!isTopic) {
            this.assertQueueLength(100);
        }
    }

    private void assertQueueLength(int len) throws Exception, IOException {
        Set destinations = this.broker.getBroker().getDestinations((ActiveMQDestination)new ActiveMQQueue(QUEUE_NAME));
        Queue queue = (Queue)destinations.iterator().next();
        Assert.assertEquals((long)len, (long)queue.getMessageStore().getMessageCount());
    }

    protected BrokerService createBroker(PersistenceAdapter kaha) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(true);
        broker.setBrokerName("localhost");
        broker.setPersistenceAdapter(kaha);
        return broker;
    }

    protected KahaDBPersistenceAdapter createStore(boolean delete) throws IOException {
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        kaha.setJournalMaxFileLength(0x2000000);
        kaha.setCleanupInterval(5000L);
        if (delete) {
            kaha.deleteAllMessages();
        }
        return kaha;
    }

    public void prepareBrokerWithMultiStore(boolean deleteAllMessages) throws Exception {
        MultiKahaDBPersistenceAdapter multiKahaDBPersistenceAdapter = new MultiKahaDBPersistenceAdapter();
        if (deleteAllMessages) {
            multiKahaDBPersistenceAdapter.deleteAllMessages();
        }
        ArrayList<FilteredKahaDBPersistenceAdapter> adapters = new ArrayList<FilteredKahaDBPersistenceAdapter>();
        FilteredKahaDBPersistenceAdapter adapter1 = new FilteredKahaDBPersistenceAdapter();
        adapter1.setPersistenceAdapter((PersistenceAdapter)this.createStore(deleteAllMessages));
        adapter1.setTopic(">");
        adapters.add(adapter1);
        FilteredKahaDBPersistenceAdapter adapter2 = new FilteredKahaDBPersistenceAdapter();
        adapter2.setPersistenceAdapter((PersistenceAdapter)this.createStore(deleteAllMessages));
        adapter2.setPerDestination(true);
        adapters.add(adapter2);
        multiKahaDBPersistenceAdapter.setFilteredPersistenceAdapters(adapters);
        this.broker = this.createBroker((PersistenceAdapter)multiKahaDBPersistenceAdapter);
    }
}

