/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.demo;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SimpleConsumer {
    private static final Log LOG = LogFactory.getLog(SimpleConsumer.class);

    private SimpleConsumer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String destinationName = null;
        InitialContext jndiContext = null;
        ConnectionFactory connectionFactory = null;
        Connection connection = null;
        Session session = null;
        Destination destination = null;
        MessageConsumer consumer = null;
        if (args.length != 1) {
            LOG.info((Object)"Usage: java SimpleConsumer <destination-name>");
            System.exit(1);
        }
        destinationName = args[0];
        LOG.info((Object)("Destination name is " + destinationName));
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException e) {
            LOG.info((Object)("Could not create JNDI API context: " + e.toString()));
            System.exit(1);
        }
        try {
            connectionFactory = (ConnectionFactory)jndiContext.lookup("ConnectionFactory");
            destination = (Destination)jndiContext.lookup(destinationName);
        }
        catch (NamingException e) {
            LOG.info((Object)("JNDI API lookup failed: " + e.toString()));
            System.exit(1);
        }
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            consumer = session.createConsumer(destination);
            connection.start();
            while (true) {
                Message m;
                if ((m = consumer.receive(1L)) == null) {
                    continue;
                }
                if (m instanceof TextMessage) {
                    TextMessage message = (TextMessage)m;
                    LOG.info((Object)("Reading message: " + message.getText()));
                    continue;
                }
                break;
            }
        }
        catch (JMSException e) {
            LOG.info((Object)("Exception occurred: " + String.valueOf((Object)e)));
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
    }
}

