/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.CompositeDestinationFilter;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.PrefixDestinationFilter;
import org.apache.activemq.filter.WildcardDestinationFilter;

public class DestinationFilterTest
extends TestCase {
    public void testPrefixFilter() throws Exception {
        DestinationFilter filter = DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQQueue(">"));
        DestinationFilterTest.assertTrue((String)("Filter not parsed well: " + String.valueOf(filter.getClass())), (boolean)(filter instanceof PrefixDestinationFilter));
        System.out.println(filter);
        DestinationFilterTest.assertFalse((String)"Filter matched wrong destination type", (boolean)filter.matches((ActiveMQDestination)new ActiveMQTopic(">")));
    }

    public void testWildcardFilter() throws Exception {
        DestinationFilter filter = DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQQueue("A.*"));
        DestinationFilterTest.assertTrue((String)("Filter not parsed well: " + String.valueOf(filter.getClass())), (boolean)(filter instanceof WildcardDestinationFilter));
        DestinationFilterTest.assertFalse((String)"Filter matched wrong destination type", (boolean)filter.matches((ActiveMQDestination)new ActiveMQTopic("A.B")));
    }

    public void testCompositeFilter() throws Exception {
        DestinationFilter filter = DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQQueue("A.B,B.C"));
        DestinationFilterTest.assertTrue((String)("Filter not parsed well: " + String.valueOf(filter.getClass())), (boolean)(filter instanceof CompositeDestinationFilter));
        DestinationFilterTest.assertFalse((String)"Filter matched wrong destination type", (boolean)filter.matches((ActiveMQDestination)new ActiveMQTopic("A.B")));
    }

    public void testMatchesChild() throws Exception {
        DestinationFilter filter = DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQQueue("A.*.C"));
        DestinationFilterTest.assertFalse((String)"Filter matched wrong destination type", (boolean)filter.matches((ActiveMQDestination)new ActiveMQTopic("A.B")));
        DestinationFilterTest.assertTrue((String)"Filter did not match", (boolean)filter.matches((ActiveMQDestination)new ActiveMQQueue("A.B.C")));
        filter = DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQQueue("A.*"));
        DestinationFilterTest.assertTrue((String)"Filter did not match", (boolean)filter.matches((ActiveMQDestination)new ActiveMQQueue("A.B")));
        DestinationFilterTest.assertFalse((String)"Filter did match", (boolean)filter.matches((ActiveMQDestination)new ActiveMQQueue("A")));
    }

    public void testMatchesAny() throws Exception {
        DestinationFilter filter = DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQQueue("A.>.>"));
        DestinationFilterTest.assertTrue((String)"Filter did not match", (boolean)filter.matches((ActiveMQDestination)new ActiveMQQueue("A.C")));
        DestinationFilterTest.assertFalse((String)"Filter did match", (boolean)filter.matches((ActiveMQDestination)new ActiveMQQueue("B")));
        DestinationFilterTest.assertTrue((String)"Filter did not match", (boolean)filter.matches((ActiveMQDestination)new ActiveMQQueue("A.B")));
        DestinationFilterTest.assertTrue((String)"Filter did not match", (boolean)filter.matches((ActiveMQDestination)new ActiveMQQueue("A.B.C.D.E.F")));
        DestinationFilterTest.assertTrue((String)"Filter did not match", (boolean)filter.matches((ActiveMQDestination)new ActiveMQQueue("A")));
    }
}

